<?php
/**
 * The header for our theme
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @package fastrans
 * @since   1.0
 * @version 1.0
 */
$options = fastrans_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );
$icon_href = $options->get( 'image_favicon' ); 
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
    
	<?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ): ?>
		<?php if( $icon_href ):?>
        <link rel="shortcut icon" href="<?php echo esc_url($icon_href['url']); ?>" type="image/x-icon">
		<link rel="icon" href="<?php echo esc_url($icon_href['url']); ?>" type="image/x-icon">
	<?php endif; endif; ?>
	<!-- responsive meta -->
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!-- For IE -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php wp_head(); ?>
    
    <style id="clock-animations"></style>
</head>


<body <?php body_class(); ?>>

<?php
if (! function_exists('wp_body_open')) {
    function wp_body_open()
    {
        do_action('wp_body_open');
    }

	//Light Color Logo Settings
	$light_image_logo = $options->get('light_image_normal_logo');
	$light_image_logo = ($light_image_logo) ? $light_image_logo : get_template_directory_uri() . '/assets/images/logo/logo3.png';
	$light_logo_dimension = $options->get('light_normal_logo_dimension');
	
}?>

<div class="page-wrapper">
 	
    <!-- Preloader -->
	<?php if( $options->get( 'theme_preloader' ) ):?>
    <div id="preloader"></div>
    <div class="up">
        <a href="#" class="scrollup text-center"><i class="fas fa-chevron-up"></i></a>
    </div>
	<?php endif; ?>

    <!-- Start of header section
	============================================= -->
	<header id="ft-header" class="ft-header-section header-style-two">
		<div class="ft-header-main-menu-wrapper">
			<div class="container">
				<div class="ft-header-main-menu d-flex align-items-center justify-content-between">
					<div class="ft-site-logo-area">
						<div class="ft-site-logo position-relative">
							<?php echo fastrans_logo($logo_type, $light_image_logo, $light_logo_dimension, $logo_text, $logo_typography, $logo_title); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</header>
	<!-- End of header section
	============================================= -->