<?php

require_once get_template_directory() . '/includes/loader.php';


/**
 * Check if WooCommerce is activated
 */
if (class_exists('WooCommerce')) {
    require_once get_template_directory() . '/woocommerce/woo-functions.php';
}

add_action( 'after_setup_theme', 'fastrans_setup_theme' );
add_action( 'after_setup_theme', 'fastrans_load_default_hooks' );
function fastrans_setup_theme() {

	load_theme_textdomain( 'fastrans', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );
	add_theme_support( 'custom-header' );
	add_theme_support( 'custom-background' );
	add_theme_support('woocommerce');
	add_theme_support('wc-product-gallery-lightbox');

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'editor-styles' );
    

remove_theme_support( 'widgets-block-editor' );
	// Set the default content width.
	$GLOBALS['content_width'] = 525;
	
	/*---------- Register image sizes ----------*/
	
	//Register image sizes
	add_image_size( 'fastrans_370x290', 370, 290, true ); //fastrans_370x290 Our Services
	add_image_size( 'fastrans_480x700', 480, 700, true ); //fastrans_480x700 Our Projects
	add_image_size( 'fastrans_387x231', 387, 231, true ); //fastrans_387x231 Our Testimonials
	add_image_size( 'fastrans_375x254', 375, 254, true ); //fastrans_375x254 Latest News
	add_image_size( 'fastrans_270x150', 270, 150, true ); //fastrans_270x150 What We Do
	add_image_size( 'fastrans_270x330', 270, 330, true ); //fastrans_270x330 Our Team
	add_image_size( 'fastrans_770x429', 770, 429, true ); //fastrans_770x429 Our Projects V2
	add_image_size( 'fastrans_70x70', 70, 70, true ); //fastrans_70x70 Our Testimonials V2
	add_image_size( 'fastrans_570x310', 570, 310, true ); //fastrans_570x310 Latest News V2
	add_image_size( 'fastrans_200x169', 200, 169, true ); //fastrans_200x169 Latest News V2
	add_image_size( 'fastrans_370x290', 370, 290, true ); //fastrans_370x290 What We Do V2
	add_image_size( 'fastrans_473x500', 473, 500, true ); //fastrans_473x500 Our Projects V3
	add_image_size( 'fastrans_370x230', 370, 230, true ); //fastrans_370x230 Latest News V3
	add_image_size( 'fastrans_1170x440', 1170, 440, true ); //fastrans_1170x440 Our Blog
	add_image_size( 'fastrans_371x233', 371, 233, true ); //fastrans_371x233 Our Blog
	/*---------- Register image sizes ends ----------*/
	
	// This theme uses wp_nav_menu() in two locations.
	register_nav_menus( array(
		'main_menu' => esc_html__( 'Main Menu', 'fastrans' ),
		'onepage_menu' => esc_html__( 'Onepage Menu', 'fastrans' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Add theme support for Custom Logo.
	add_theme_support( 'custom-logo', array(
		'width'      => 250,
		'height'     => 250,
		'flex-width' => true,
	) );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, and column width.
 	 */
	add_editor_style();
	add_action( 'admin_init', 'fastrans_admin_init', 2000000 );
}

/**
 * [fastrans_admin_init]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */


function fastrans_admin_init() {
	remove_action( 'admin_notices', array( 'ReduxFramework', '_admin_notices' ), 99 );
}

/*---------- Sidebar settings ----------*/

/**
 * [fastrans_widgets_init]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */
function fastrans_widgets_init() {

	global $wp_registered_sidebars;

	$theme_options = get_theme_mod( 'fastrans' . '_options-mods' );

	register_sidebar( array(
		'name'          => esc_html__( 'Default Sidebar', 'fastrans' ),
		'id'            => 'default-sidebar',
		'description'   => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'fastrans' ),
		'before_widget' => '<div id="%1$s" class="widget ft-side-bar-widget headline ul-li-block %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title position-relative">',
		'after_title'   => '</h3>',
	) );
	register_sidebar(array(
		'name' => esc_html__('Footer Widget', 'fastrans'),
		'id' => 'footer-sidebar',
		'description' => esc_html__('Widgets in this area will be shown in Footer Area.', 'fastrans'),
		'before_widget'=>'<div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 wow animated fadeInUp"><div id="%1$s" class="footer-widget ft-footer-widget %2$s">',
		'after_widget'=>'</div></div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>'
	));
	if ( class_exists( '\Elementor\Plugin' )){
	register_sidebar(array(
		'name' => esc_html__('Footer Widget Two', 'fastrans'),
		'id' => 'footer-sidebar2',
		'description' => esc_html__('Widgets in this area will be shown in Footer Area.', 'fastrans'),
		'before_widget'=>'<div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 wow animated fadeInUp"><div id="%1$s" class="footer-widget ft-footer-widget %2$s">',
		'after_widget'=>'</div></div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>'
	));
	register_sidebar(array(
		'name' => esc_html__('Footer Widget Three', 'fastrans'),
		'id' => 'footer-sidebar3',
		'description' => esc_html__('Widgets in this area will be shown in Footer Area.', 'fastrans'),
		'before_widget'=>'<div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 wow animated fadeInUp"><div id="%1$s" class="footer-widget ft-footer-widget %2$s">',
		'after_widget'=>'</div></div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>'
	));
	register_sidebar(array(
		'name' => esc_html__('Footer Widget Four', 'fastrans'),
		'id' => 'footer-sidebar4',
		'description' => esc_html__('Widgets in this area will be shown in Footer Area.', 'fastrans'),
		'before_widget'=>'<div id="%1$s" class="footer-widget ft-footer-widget-4 %2$s">',
		'after_widget'=>'</div>',
		'before_title' => '<h4 class="widget-title">',
		'after_title' => '</h4>'
	));

    register_sidebar(array(
        'name' => esc_html__('Footer Widget Six', 'fastrans'),
        'id' => 'footer-sidebar-v6',
        'description' => esc_html__('Widgets in this area will be shown in Footer Area.', 'fastrans'),
        'before_widget'=>'<div class="footer-column col-lg-3 col-md-6 col-sm-12"><div id="%1$s" class="footer-widget %2$s">',
        'after_widget'=>'</div></div>',
        'before_title' => '<h5 class="widget-title">',
        'after_title' => '</h5>'
    ));
	register_sidebar(array(
		'name' => esc_html__('Services Widget', 'fastrans'),
		'id' => 'service-sidebar',
		'description' => esc_html__('Widgets in this area will be shown in Services Area.', 'fastrans'),
		'before_widget'=>'<div id="%1$s" class="service-widget sidebar-widget %2$s">',
		'after_widget'=>'</div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>'
	));
	}
	register_sidebar(array(
	  'name' => esc_html__( 'Blog Listing', 'fastrans' ),
	  'id' => 'blog-sidebar',
	  'description' => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'fastrans' ),
	  'before_widget'=>'<div id="%1$s" class="widget ft-side-bar-widget headline ul-li-block %2$s">',
	  'after_widget'=>'</div>',
	  'before_title' => '<h3 class="widget-title position-relative">',
	  'after_title' => '</h3>'
	));
	if ( ! is_object( fastrans_WSH() ) ) {
		return;
	}

	$sidebars = fastrans_set( $theme_options, 'custom_sidebar_name' );

	foreach ( array_filter( (array) $sidebars ) as $sidebar ) {

		if ( fastrans_set( $sidebar, 'topcopy' ) ) {
			continue;
		}

		$name = $sidebar;
		if ( ! $name ) {
			continue;
		}
		$slug = str_replace( ' ', '_', $name );

		register_sidebar( array(
			'name'          => $name,
			'id'            => sanitize_title( $slug ),
			'before_widget' => '<div id="%1$s" class="%2$s widget ft-side-bar-widget headline ul-li-block">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title position-relative">',
			'after_title'   => '</h3>',
		) );
	}

	update_option( 'wp_registered_sidebars', $wp_registered_sidebars );
}

add_action( 'widgets_init', 'fastrans_widgets_init' );

/*---------- Sidebar settings ends ----------*/

/*---------- Gutenberg settings ----------*/

function fastrans_gutenberg_editor_palette_styles() {
    add_theme_support( 'editor-color-palette', array(
        array(
            'name' => esc_html__( 'strong yellow', 'fastrans' ),
            'slug' => 'strong-yellow',
            'color' => '#f7bd00',
        ),
        array(
            'name' => esc_html__( 'strong white', 'fastrans' ),
            'slug' => 'strong-white',
            'color' => '#fff',
        ),
		array(
            'name' => esc_html__( 'light black', 'fastrans' ),
            'slug' => 'light-black',
            'color' => '#242424',
        ),
        array(
            'name' => esc_html__( 'very light gray', 'fastrans' ),
            'slug' => 'very-light-gray',
            'color' => '#797979',
        ),
        array(
            'name' => esc_html__( 'very dark black', 'fastrans' ),
            'slug' => 'very-dark-black',
            'color' => '#000000',
        ),
    ) );
	
	add_theme_support( 'editor-font-sizes', array(
		array(
			'name' => esc_html__( 'Small', 'fastrans' ),
			'size' => 10,
			'slug' => 'small'
		),
		array(
			'name' => esc_html__( 'Normal', 'fastrans' ),
			'size' => 15,
			'slug' => 'normal'
		),
		array(
			'name' => esc_html__( 'Large', 'fastrans' ),
			'size' => 24,
			'slug' => 'large'
		),
		array(
			'name' => esc_html__( 'Huge', 'fastrans' ),
			'size' => 36,
			'slug' => 'huge'
		)
	) );
	
}
add_action( 'after_setup_theme', 'fastrans_gutenberg_editor_palette_styles' );

/*---------- Gutenberg settings ends ----------*/

/*---------- Enqueue Styles and Scripts ----------*/

function fastrans_enqueue_scripts() {
	$options = fastrans_WSH()->option();
	
    //styles
	wp_enqueue_style( 'fontawesome-all', get_template_directory_uri() . '/assets/css/fontawesome-all.css' );
	wp_enqueue_style( 'flaticon', get_template_directory_uri() . '/assets/css/flaticon.css' );
    wp_enqueue_style( 'flaticon-home-v7', get_template_directory_uri() . '/assets/css/icon-v7/flaticon-v7.css' );
	wp_enqueue_style( 'flaticon-v2.css', get_template_directory_uri() . '/assets/css/flaticon-v2.css' );
	wp_enqueue_style( 'jquery-ui', get_template_directory_uri() . '/assets/css/jquery-ui.css' );
	wp_enqueue_style( 'animate', get_template_directory_uri() . '/assets/css/animate.css' );
	wp_enqueue_style( 'nice-select', get_template_directory_uri() . '/assets/css/nice-select.css' );
	wp_enqueue_style( 'video', get_template_directory_uri() . '/assets/css/video.min.css' );
	wp_enqueue_style( 'animated-slider', get_template_directory_uri() . '/assets/css/animated-slider.css' );
	wp_enqueue_style( 'jquery-mcustomscrollbar', get_template_directory_uri() . '/assets/css/jquery.mCustomScrollbar.min.css' );
	wp_enqueue_style( 'slick', get_template_directory_uri() . '/assets/css/slick.css' );
	//wp_enqueue_style( 'rs6', get_template_directory_uri() . '/assets/css/rs6.css' );
	wp_enqueue_style( 'slick-theme', get_template_directory_uri() . '/assets/css/slick-theme.css' );
	wp_enqueue_style( 'animate-team', get_template_directory_uri() . '/assets/css/animate-team.css' );
	wp_enqueue_style( 'fastrans-woocommerce', get_template_directory_uri() . '/woocommerce/woocommerce.css' );
	wp_enqueue_style( 'fastrans-main', get_stylesheet_uri() );

	if (is_rtl()) {		
		wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css' );
		wp_enqueue_style( 'fastrans-main-style', get_template_directory_uri() . '/assets/css/style.css', '1.1' );
		wp_enqueue_style( 'fastrans-rtl', get_template_directory_uri() . '/assets/css/rtl.css', '1.1' );
		wp_enqueue_style( 'fastrans-updated-style', get_template_directory_uri() . '/assets/css/updated-style.css' );
		wp_enqueue_style( 'fastrans-custom', get_template_directory_uri() . '/assets/css/custom.css' );
		wp_enqueue_style( 'fastrans-responsive', get_template_directory_uri() . '/assets/css/responsive.css' );
	}else{		
		wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css' );
		wp_enqueue_style( 'owl-carousel', get_template_directory_uri() . '/assets/css/owl.carousel.min.css' );
		wp_enqueue_style( 'fastrans-main-style', get_template_directory_uri() . '/assets/css/style.css', '1.1' );
		wp_enqueue_style( 'fastrans-updated-style', get_template_directory_uri() . '/assets/css/updated-style.css' );
		wp_enqueue_style( 'fastrans-custom', get_template_directory_uri() . '/assets/css/custom.css' );
		wp_enqueue_style( 'fastrans-responsive', get_template_directory_uri() . '/assets/css/responsive.css' );
	}
	wp_enqueue_style( 'fastrans-main-style', get_template_directory_uri() . '/assets/css/style.css', '1.1' );
	wp_enqueue_style( 'fastrans-updated-style', get_template_directory_uri() . '/assets/css/updated-style.css' );
	wp_enqueue_style( 'fastrans-custom', get_template_directory_uri() . '/assets/css/custom.css' );
	wp_enqueue_style( 'fastrans-transport', get_template_directory_uri() . '/assets/css/transport.css' );
    wp_enqueue_style( 'home_v7', get_template_directory_uri() . '/assets/css/home_v7.css' );
    wp_enqueue_style( 'fastrans-responsive', get_template_directory_uri() . '/assets/css/responsive.css' );
	wp_enqueue_style( 'transport-responsive', get_template_directory_uri() . '/assets/css/transport-responsive.css' );


    //scripts
	wp_enqueue_script( 'jquery-ui-core');
    wp_enqueue_script( 'popper', get_template_directory_uri().'/assets/js/popper.min.js', array( 'jquery' ), '2.1.2', true );
    wp_enqueue_script( 'bootstrap', get_template_directory_uri().'/assets/js/bootstrap.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'jquery-ui', get_template_directory_uri().'/assets/js/jquery-ui.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'jquery-touch-punch', get_template_directory_uri().'/assets/js/jquery.ui.touch-punch.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'jquery-magnific-popup', get_template_directory_uri().'/assets/js/jquery.magnific-popup.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'owl-carousel', get_template_directory_uri().'/assets/js/owl.carousel.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'appear', get_template_directory_uri().'/assets/js/appear.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'slick', get_template_directory_uri().'/assets/js/slick.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'jquery-counterup', get_template_directory_uri().'/assets/js/jquery.counterup.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'waypoints', get_template_directory_uri().'/assets/js/waypoints.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'imagesloaded', get_template_directory_uri().'/assets/js/imagesloaded.pkgd.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'jquery-mcustomscrollbar', get_template_directory_uri().'/assets/js/jquery.mCustomScrollbar.concat.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'wow', get_template_directory_uri().'/assets/js/wow.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'jquery-css-slider', get_template_directory_uri().'/assets/js/jquery.cssslider.min.js', array( 'jquery' ), '2.1.2', true );
	if(is_page( 'home-page-05' )){
		wp_enqueue_script( 'animate-team-slider', get_template_directory_uri().'/assets/js/team.js', array( 'jquery' ), '2.1.2', true );
	}
	wp_enqueue_script( 'rbtools', get_template_directory_uri().'/assets/js/rbtools.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'animation-loading', get_template_directory_uri().'/assets/js/animation-loading.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'jquery-css-slider', get_template_directory_uri().'/assets/js/jquery.cssslider.min.js', array( 'jquery' ), '2.1.2', true );
	//wp_enqueue_script( 'rs6', get_template_directory_uri().'/assets/js/rs6.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'knob', get_template_directory_uri().'/assets/js/knob.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'typer', get_template_directory_uri().'/assets/js/typer.js', array( 'jquery' ), '2.1.2', true );
	//wp_enqueue_script( 'rs6', get_template_directory_uri().'/assets/js/rs6.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'mixitup', get_template_directory_uri().'/assets/js/mixitup.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'fastrans-main-script', get_template_directory_uri().'/assets/js/script.js', array(), false, true );
	wp_enqueue_script( 'fastrans-script-new', get_template_directory_uri().'/assets/js/script-new.js', array(), false, true );
	wp_enqueue_script( 'fastrans-transport-script', get_template_directory_uri().'/assets/js/transport-script.js', array(), false, true );
	if( is_singular() ) wp_enqueue_script('comment-reply');
}
add_action( 'wp_enqueue_scripts', 'fastrans_enqueue_scripts' );

/*---------- Enqueue styles and scripts ends ----------*/

/*---------- Google fonts ----------*/

function fastrans_fonts_url() {
	
	$fonts_url = '';
	
		
		$font_families['Poppins']      = 'Poppins:100,200,300,400,600,500,700';
		$font_families['Roboto']      = 'Roboto:100,300,400,500,700';

		$font_families = apply_filters( 'REXAR/includes/classes/header_enqueue/font_families', $font_families );

		$query_args = array(
			'family' => urlencode( implode( '|', $font_families ) ),
			'subset' => urlencode( 'latin,latin-ext' ),
		);

		$protocol  = is_ssl() ? 'https' : 'http';
		$fonts_url = add_query_arg( $query_args, $protocol . '://fonts.googleapis.com/css' );

		return esc_url_raw($fonts_url);

}

function fastrans_theme_styles() {
    wp_enqueue_style( 'fastrans-theme-fonts', fastrans_fonts_url(), array(), null );
    wp_enqueue_style( 'flaticon-home-v7', get_template_directory_uri() . '/assets/css/icon-v7/flaticon-v7.css' );
}

add_action( 'wp_enqueue_scripts', 'fastrans_theme_styles' );
add_action( 'admin_enqueue_scripts', 'fastrans_theme_styles' );

/*---------- Google fonts ends ----------*/

/*---------- More functions ----------*/

// 1) fastrans_set function

/**
 * [fastrans_set description]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */
if ( ! function_exists( 'fastrans_set' ) ) {
	function fastrans_set( $var, $key, $def = '' ) {

		if ( is_object( $var ) && isset( $var->$key ) ) {
			return $var->$key;
		} elseif ( is_array( $var ) && isset( $var[ $key ] ) ) {
			return $var[ $key ];
		} elseif ( $def ) {
			return $def;
		} else {
			return false;
		}
	}
}

// 2) fastrans_add_editor_styles function

function fastrans_add_editor_styles() {
    add_editor_style( 'editor-style.css' );
}
add_action( 'admin_init', 'fastrans_add_editor_styles' );

// 3) Add specific CSS class by filter body class.

$options = fastrans_WSH()->option(); 
if( fastrans_set($options, 'boxed_wrapper') ){

add_filter( 'body_class', function( $classes ) {
    $classes[] = 'boxed_wrapper';
    return $classes;
} );
}


