<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Transport_Cta_Widget extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_transport_cta_widget';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Transport CTA Widget', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'our_testimonials_v5',
			[
				'label' => esc_html__( 'Our testimonials V5', 'fastrans' ),
			]
		);
        $this->add_control(
            'cta_bg', [
                'label'       => esc_html__( 'CTA Background', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'cta_title', [
                'label'       => esc_html__( 'CTA Title', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'cta_btn', [
                'label'       => esc_html__( 'CTA Button', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'cta_btn_link', [
                'label'       => esc_html__( 'CTA Button Link', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::URL,
                'label_block' => true,
            ]
        );
		$this->end_controls_section();
	}
	
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$cta_bg = $settings['cta_bg']['url'];
		$cta_title = $settings['cta_title'];
		$cta_btn = $settings['cta_btn'];
		$cta_btn_link = $settings['cta_btn_link'];
        
        ?>
        <section class="cta-section-two" style="background-image:url(<?php echo esc_url($cta_bg);?>)">
			<div class="auto-container">
				<div class="content">
					<h3><?php echo __($cta_title);?></h3>
					<a href="<?php echo esc_url($cta_btn_link['url']);?>" class="theme-btn read-more"><?php echo esc_html($cta_btn);?> <span class="fa fa-angle-right"></span></a>
				</div>
			</div>
		</section>
                <!-- End Testimonial Section Three -->
        <?php 
	}
    
}