<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Testimonial_V7 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'testimonial_v7';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Testimonial V7', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return ' eicon-form-horizontal';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'testimonial_section',
				[
					'label' => esc_html__( 'Testimonial Section', 'fastrans' ),
				]
		);
        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Customer Feedback', 'fastrans' ),
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__( 'Sub Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'What Pepole Say About Our Company', 'fastrans' ),
            ]
        );
        $this->add_control(
            'info',
            [
                'label' => esc_html__( 'Information', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Quis ipsum suspendisse ultrices gravida. Risus commodo vis.', 'fastrans' ),
            ]
        );
		$this->end_controls_section();

        $this->start_controls_section(
            'testimonial_box_section',
            [
                'label' => __( 'Client Testimonial', 'fastrans' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'comment',
            [
                'label' => esc_html__( 'Comment', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'Contrary to popular belief, Lorem Ipsum isnot simply random text. It has roots in a piece of  Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur,', 'fastrans' ),
            ]
        );
        $repeater->add_control(
            'image',
            [
                'label' => esc_html__( 'Choose Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'name',
            [
                'label' => esc_html__( 'Name', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Donald Gigliotti', 'fastrans' ),
            ]
        );
        $repeater->add_control(
            'designation',
            [
                'label' => esc_html__( 'Designation', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Ceo Founder', 'fastrans' ),
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__( 'Testimonial List', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'name' => esc_html__( 'Donald Gigliotti', 'fastrans' ),
                    ],[
                        'name' => esc_html__( 'Donald Gigliotti', 'fastrans' ),
                    ],[
                        'name' => esc_html__( 'Donald Gigliotti', 'fastrans' ),
                    ],
                ],
                'title_field' => '{{{ name }}}',
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'testimonial_section_style',
			[
				'label' => esc_html__( 'Testimonial Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'testimonial_bg_color',
			[
				'label'     => esc_html__( 'Section Background Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-section' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title .title' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'title_typography',
                'label'          => esc_html__( 'Title Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .sec-title .title',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
		$this->add_control(
			'sub_title_color',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sub_title_typography',
				'label'          => esc_html__( 'Sub Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .sec-title h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
        $this->add_control(
            'description_color',
            [
                'label'     => esc_html__( 'Description Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-section .sec-title .text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'description_typography',
                'label'          => esc_html__( 'Description Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .testimonial-section .sec-title .text',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
		$this->end_controls_section();
        $this->start_controls_section(
            'testimonial_box_style',
            [
                'label' => __( 'Client Testimonial Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            '_testimonial_box_style_',
            [
                'label' => esc_html__( 'Testimonial Box Style', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            '_testimonial_bg_color',
            [
                'label'     => esc_html__( 'Testimonial BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-block .inner-box' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            '_testimonial_hover_bg_color',
            [
                'label'     => esc_html__( 'Testimonial Hover BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-block .inner-box:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            '_testimonial_icon_style_',
            [
                'label' => esc_html__( 'Testimonial Icon Style', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'icon_bg_color',
            [
                'label'     => esc_html__( 'Icon BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-block .inner-box .quote-icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label'     => esc_html__( 'Icon Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-block .inner-box .quote-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            '_comment_style_',
            [
                'label' => esc_html__( 'Comment Style', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'comment_color',
            [
                'label'     => esc_html__( 'Comment Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-block .inner-box .text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'comment_typography',
                'label'          => esc_html__( 'Comment Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .testimonial-block .inner-box .text',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
        $this->add_control(
            '_name_style_',
            [
                'label' => esc_html__( 'Name Style', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'name_color',
            [
                'label'     => esc_html__( 'Name Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-block .inner-box .author-info h6' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'name_typography',
                'label'          => esc_html__( 'Name Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .testimonial-block .inner-box .author-info h6',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );

        $this->add_control(
            '_designation_style_',
            [
                'label' => esc_html__( 'Designation Style', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'designation_color',
            [
                'label'     => esc_html__( 'Designation Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-block .inner-box .author-info .designation' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'designation_typography',
                'label'          => esc_html__( 'Designation Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .testimonial-block .inner-box .author-info .designation',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );

        $this->add_control(
            '_slide_btn_style_',
            [
                'label' => esc_html__( 'Navigation Button Style', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'navigation_active_color',
            [
                'label'     => esc_html__( 'Navigation Active Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-section .owl-dots .owl-dot.active' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'navigation_in_active_color',
            [
                'label'     => esc_html__( 'Navigation Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-section .owl-dots .owl-dot' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'navigation_hover_color',
            [
                'label'     => esc_html__( 'Navigation Hover Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-section .owl-dots .owl-dot:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();

	?>

        <!-- Testimonial Section -->
        <section class="testimonial-section">
            <div class="auto-container">
                <div class="sec-title">
                    <div class="clearfix">
                        <div class="pull-left">
                            <div class="title"><?php echo $settings['title']; ?></div>
                            <h2><?php echo $settings['sub_title']; ?></h2>
                        </div>
                        <div class="pull-right">
                            <div class="text"><?php echo $settings['info']; ?></div>
                        </div>
                    </div>
                </div>
                <div class="testimonial-carousel owl-carousel owl-theme">
                <?php
                    foreach ($settings['items'] as $item):
                ?>
                    <!-- Testimonial Block -->
                    <div class="testimonial-block">
                        <div class="inner-box">
                            <div class="quote-icon">
                                <i aria-hidden="true" class="flaticonv7 flaticonv7-quote-1"></i>
                            </div>
                            <div class="text"><?php echo $item['comment']; ?></div>
                            <div class="author-info">
                                <div class="author-inner">
                                    <div class="author-image">
                                        <img src="<?php echo $item['image']['url']; ?>" alt="" />
                                    </div>
                                    <h6><?php echo $item['name']; ?></h6>
                                    <div class="designation"><?php echo $item['designation']; ?></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php
                        endforeach;
                    ?>


                </div>
            </div>
        </section>
        <!-- End Testimonial Section -->

    <?php 
	
	}

}