<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Project_Details extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_project_details';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Project Details', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'project_details',
				[
					'label' => esc_html__( 'Project Details', 'fastrans' ),
				]
		);
		$this->add_control(
			'project_image',
			[
			  'label' => __( 'Feature Image', 'fastrans' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'project_detail_title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Project detail Title Here', 'fastrans' ),
			]
		);
		$this->add_control(
            'project_info', 
			  	[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
				[
					['block_title' => esc_html__('Name:', 'fastrans')],
					['block_title' => esc_html__('Date:', 'fastrans')],
					['block_title' => esc_html__('Author:', 'fastrans')],
					['block_title' => esc_html__('Tag:', 'fastrans')]
				],
			'fields' => 
				[
					[
						'name' => 'block_title',
						'label' => esc_html__('Title', 'fastrans'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('', 'fastrans')
					],
					[
						'name' => 'block_text',
						'label' => esc_html__('Description', 'fastrans'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('', 'fastrans')
					],
				],
				'title_field' => '{{block_title}}',
            ]
        );
		$this->add_control(
			'project_value',
			[
				'label'       => __( 'Project Value', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Project Value', 'fastrans' ),
			]
		);
		$this->add_control(
			'project_rating',
			[
				'label'   => esc_html__( 'Choose Project Rating', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => '5',
				'options' => array(
					'1'      => esc_html__( 'One Star', 'fastrans' ),
					'2'      => esc_html__( 'Two Star', 'fastrans' ),
					'3' 	 => esc_html__( 'Three Star', 'fastrans' ),
					'4'      => esc_html__( 'Four Star', 'fastrans' ),
					'5'      => esc_html__( 'Five Star', 'fastrans' ),
				),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Main Heading', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Main Heading', 'fastrans' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Description', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'fastrans' ),
			]
		);
		$this->add_control(
            'features_list', 
			  	[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
				[
					['list_description' => esc_html__('The housekeepers we hired are professionals who take pride in doing excellent work and in exceeding expectations.', 'fastrans')],
					['list_description' => esc_html__('We carefully screen all of our cleaners you can rest assured that your home would receive the absolute highest quality of service providing.', 'fastrans')],
					['list_description' => esc_html__('Your time is precious, and we understand that cleaning is really just one more item on your to-do list.', 'fastrans')]
				],
			'fields' => 
				[
					[
						'name' => 'list_description',
						'label' => esc_html__('Description', 'fastrans'),
						'label_block' => true,
						'type' => Controls_Manager::TEXTAREA,
						'default' => esc_html__('', 'fastrans')
					],
				],
				'title_field' => '{{list_description}}',
            ]
        );
		$this->add_control(
            'show_author_area',
			[
				'label' => __( 'Enable/Disable Author Info', 'fastrans' ),
				'type'     => Controls_Manager::SWITCHER,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enable/Disable Author Info', 'fastrans' ),
			]
		);
		$this->add_control(
			'author_image',
			[
			  'label' => __( 'Author Image', 'fastrans' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'author_description',
			[
				'label'       => __( 'Author Description', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Author Description', 'fastrans' ),
			]
		);
		$this->add_control(
			'author_title',
			[
				'label'       => __( 'Author Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Author Title Here', 'fastrans' ),
			]
		);
		$this->add_control(
			'author_designation',
			[
				'label'       => __( 'Author Designation', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Author Designation Here', 'fastrans' ),
			]
		);
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>
	
    <!-- Start of Project details  section
	============================================= -->
	<section id="ft-project-details" class="ft-project-details-section page-padding">
		<div class="container">
			<div class="ft-project-overview">
				<div class="row">
					<?php if($settings['project_image']['id']){ ?>
                    <div class="col-lg-8">
						<div class="ft-project-details-img">
							<img src="<?php echo esc_url(wp_get_attachment_url($settings['project_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>">
						</div>
					</div>
                    <?php } ?>
					<div class="col-lg-4">
						<div class="ft-portfolio-overview-text headline">
							<?php if($settings['project_detail_title']){ ?>
                            <div class="project-title-overview text-center">
								<h3><?php echo wp_kses($settings['project_detail_title'], true); ?></h3>
							</div>
							<?php } ?>
                            <div class="ft-portfolio-overview-list-value">
								<div class="ft-portfolio-overview-list  ul-li-block">
									<ul>
										<?php foreach($settings['project_info'] as $key => $item): ?>
                                        <li><?php echo wp_kses($item['block_title'], true);?> <span><?php echo wp_kses($item['block_text'], true);?></span></li>
										<?php endforeach; ?>
									</ul>
								</div>
								<div class="ft-project-value ul-li">
									<?php if($settings['project_value']){ ?><span><?php echo wp_kses($settings['project_value'], true); ?></span><?php } ?>
									<ul>
										<?php
										$ratting = $settings['project_rating']; 
										for ($x = 1; $x <= 5; $x++) {
										if($x <= $ratting) echo '<li><i class="fas fa-star"></i></li>'; else echo '<li><i class="fal fa-star"></i>'; 
										}
										?>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="ft-project-overview-text-wrapper headline pera-content">
				<?php if($settings['title']){ ?><h3><?php echo wp_kses($settings['title'], true); ?></h3><?php } ?>
				<?php if($settings['content']){ ?><p><?php echo wp_kses($settings['content'], true); ?></p><?php } ?>
				<div class="ft-project-overview-comment-list">
					<div class="row">
						
                        <div class="col-lg-5">
							<div class="ft-project-overview-list-item ul-li-block">
								<ul>
									<?php foreach($settings['features_list'] as $key => $item): ?>
                                    <li><?php echo wp_kses($item['list_description'], true);?></li>
									<?php endforeach; ?>
								</ul>
							</div>
						</div>
						<?php if($settings['show_author_area']){ ?>
                        <div class="col-lg-7">
							<div class="ft-project-overview-comment">
								<div class="ft-project-overview-comment-wrapper d-flex align-items-center position-relative">
									<?php if($settings['author_image']['id']){ ?>
                                    <div class="ft-project-overview-comment-img">
										<img src="<?php echo esc_url(wp_get_attachment_url($settings['author_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>">
									</div>
                                    <?php } ?>
									<div class="ft-project-overview-comment-text headline">
										<?php echo wp_kses($settings['author_description'], true);?>
										<?php if($settings['author_title']){ ?><h4><?php echo wp_kses($settings['author_title'], true);?></h4><?php } ?>
										<?php if($settings['author_designation']){ ?><span><?php echo wp_kses($settings['author_designation'], true);?></span><?php } ?>
									</div>
								</div>
							</div>
						</div>
                        <?php } ?>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End of Project details section
	============================================= -->
        
    <?php 
	
	}

}