<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Team_V3 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_our_team_v3';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Team V3', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'our_team_v3',
			[
				'label' => esc_html__( 'Our Team V3', 'fastrans' ),
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title_info',
			[
				'label'       => __( 'Description', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Description', 'fastrans' ),
			]
		);
		$repeater = new Repeater();
		
		$repeater->add_control(
			'team_img', [
				'label'       => esc_html__( 'Team Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'item_id', [
				'label'       => esc_html__( 'ID', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'item_scale', [
				'label'       => esc_html__( 'Scale', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'team_count', [
				'label'       => esc_html__( 'Count', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'team_name', [
				'label'       => esc_html__( 'Team Member Name', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'designation', [
				'label'       => esc_html__( 'Designation', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'short_info', [
				'label'       => esc_html__( 'Short Info', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
			]
		);
		$repeater->add_control(
			'phone', [
				'label'       => esc_html__( 'Email/Phone', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'team_link',
			[
				'label' => __( 'Link', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'fastrans' ),
			]
		);
		$this->add_control(
			'teams',
			[
				'label'       => __( 'Add Item', 'fastrans-extension' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ team_name }}}',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'team_heading_style',
			[
				'label' => esc_html__( 'Section Heading Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'marginbtm',
			[
				'label' => __( 'Bottom Space', 'plugin-domain' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .team-section-heading' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'sh_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sh_title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-4 h2' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sh_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-4 h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'sh_sub_clr',
			[
				'label'     => esc_html__( 'Sub Heading Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-4 span' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sh_sub_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-4 span',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'content_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Content Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sh_cont_clr',
			[
				'label'     => esc_html__( 'Content Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .section-content p' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'contb_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .section-content p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'team_style',
			[
				'label' => esc_html__( 'Team Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'name_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Name Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'tm_name_clr',
			[
				'label'     => esc_html__( 'Name Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item__meta-title' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'naem_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .item__meta-title',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'item_count_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Item Count Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'item_count_clr',
			[
				'label'     => esc_html__( 'Count Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item__meta-counter' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'count_text_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .item__meta-counter',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'designation_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'designation_clr',
			[
				'label'     => esc_html__( 'Designation Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item__meta-detail' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'designation_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .item__meta-detail',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'tm_btn_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Item Button Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'tm_btn_clr',
			[
				'label'     => esc_html__( 'Designation Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item__meta-detail' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'tm_btn_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .item__meta-detail',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$teams = $settings['teams'];
		?>
		
        <!-- Start of Team  page section
        ============================================= -->
        <section id="ft-team-page" class="ft-team-page-section page-padding">
			<div class="container">
				<div class="row team-section-heading">
					<div class="col-lg-8">
						<?php if( $settings['subtitle'] || $settings['title'] ){ ?>
						<div class="ft-section-title-4 headline pera-content text-left">
							<?php if( $settings['subtitle'] ){ ?><span class="sub-title"><?php echo wp_kses($settings['subtitle'], true)?></span><?php } ?>
							<?php if( $settings['title'] ){ ?><h2><?php echo wp_kses($settings['title'], true)?></h2><?php } ?>
						</div>
						<?php } ?>
					</div>
					<div class="col-lg-4">
						<div class="section-content text-left">
							<p><?php echo __($settings['title_info']);?></p>
						</div>
					</div>
				</div>
			</div>
            <div class="container ft-team2-slider-wrapper">				
				<?php foreach($teams as $item):?>
				<div class="item">
					<figure class="thumb"> <svg class="distort" width="350" height="450" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
							<filter id="<?php echo esc_attr($item['item_id']);?>" data-type="turbulence">
								<feTurbulence type="fractalNoise" baseFrequency="0" numOctaves="1" result="warp" />
									<feDisplacementMap xChannelSelector="R" yChannelSelector="G" scale="<?php echo esc_attr($item['item_scale']);?>" in="SourceGraphic" />
							</filter>
							<image filter="url(#<?php echo esc_attr($item['item_id']);?>)" class="distort__img" x="50" y="50" xlink:href="<?php echo esc_url($item['team_img']['url']);?>" height="350" width="250" />
						</svg>
						<figcaption class="thumb__caption">
							<p class="thumb__caption-title"><?php echo __($item['short_info']);?></p> <a href="<?php echo esc_url($item['team_link']['url']);?>" class="thumb__caption-link">View Details</a>
						</figcaption>
					</figure>
					<div class="item__meta">
						<p class="item__meta-counter"><?php echo esc_attr($item['team_count']);?></p>
						<h3 class="item__meta-title"><?php echo esc_html($item['team_name']);?></h3>
						<p class="item__meta-detail"><?php echo esc_html($item['designation']);?></p>
						<p class="item__meta-detail"><i class="fa fa-phone"></i> <?php echo esc_html($item['phone']);?></p>
					</div>
				</div>
				<?php endforeach;?>
            </div>
			<svg class="cursor" width="40" height="40">
        <circle class="cursor__inner" cx="20" cy="20" r="10" /></svg>
        </section>	
    	<!-- End of Team  page section
        ============================================= -->
                         
        <?php
	}

}
