<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Skills extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_our_skills';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Skills', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'our_skills',
				[
					'label' => esc_html__( 'Our Skills', 'fastrans' ),
				]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'fastrans' ),
			]
		);
		$this->add_control(
        	'skill', 
				[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
					[
						['block_title' => esc_html__('Warehousing', 'fastrans')],
						['block_title' => esc_html__('Oceann Freight', 'fastrans')],
						['block_title' => esc_html__('Air Freight', 'fastrans')]
					],
				'fields' => 
					[
						[
							'name' => 'circle_bg_color',
							'label' => esc_html__('Circle Border Color', 'fastrans'),
							'type' => Controls_Manager::TEXT,
							'label_block' => true,
							'default' => esc_html__('#ffffff', 'fastrans')
						],
						[
							'name' => 'circle_fill_color',
							'label' => esc_html__('Circle Border Fill Color', 'fastrans'),
							'type' => Controls_Manager::TEXT,
							'label_block' => true,
							'default' => esc_html__('#f22728', 'fastrans')
						],
						[
							'name' => 'counter_value',
							'label' => esc_html__('Circle Fill Value', 'fastrans'),
							'type' => Controls_Manager::TEXT,
							'label_block' => true,
							'default' => esc_html__('', 'fastrans')
						],
						[
							'name' => 'block_title',
							'label' => esc_html__('Block Title', 'fastrans'),
							'label_block' => true,
							'type' => Controls_Manager::TEXT,
							'default' => esc_html__('', 'fastrans')
						],
					],
				'title_field' => '{{block_title}}',
            ]
        );
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>
	
    <!-- Start of Experience section
	============================================= -->
	<section id="ft-experience" class="ft-experience-section">
		<div class="container">
			<div class="ft-experience-content">
				<div class="row">
					<?php if( $settings['subtitle'] || $settings['title'] ){ ?>
                    <div class="col-lg-6">
						<div class="ft-experience-text">
							<div class="ft-section-title-2 headline pera-content">
								<?php if( $settings['subtitle'] ){ ?><span class="sub-title"><?php echo wp_kses($settings['subtitle'], true)?></span><?php } ?>
                				<?php if( $settings['title'] ){ ?><h2><?php echo wp_kses($settings['title'], true)?></h2><?php } ?>
							</div>
						</div>
					</div>
					<?php } ?>
                    <div class="col-lg-6">
						<div class="ft-experience-circle-progress">
							<div class="row">
								<?php foreach($settings['skill'] as $key => $item): ?>
                                <div class="col-lg-4">
									<div class="counter-boxed text-center headline position-relative">
										<div class="graph-outer">
											<input type="text" class="dial" data-fgColor="<?php echo esc_attr($item['circle_fill_color']);?>" data-bgColor="<?php echo esc_attr($item['circle_bg_color']);?>" data-width="80" data-height="80" data-linecap="round"  value="<?php echo esc_attr($item['counter_value']);?>" >
											<div class="inner-text count-box"><span class="count-text" data-stop="<?php echo esc_attr($item['counter_value']);?>" data-speed="3500"></span><?php esc_html_e('%', 'fastrans'); ?></div>
										</div>
										<h3><?php echo wp_kses($item['block_title'], true);?></h3>
									</div>
								</div>
                                <?php endforeach; ?>
							</div>
						</div>
					</div>	
				</div>
			</div>
		</div>
	</section>
	<!-- End of Experience section
	============================================= -->
    		
    <?php 
	
	}

}