<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Faqs extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_our_faqs';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Faqs', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'our_faqs',
			[
				'label' => esc_html__( 'Our Faqs', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'btn_title',
			[
				'label'       => __( 'Button Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title', 'fastrans' ),
			]
		);
		$this->add_control(
            'btn_link',
			[
				'label' => __( 'Button Url', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		$this->add_control(
			'text_limit',
			[
				'label'   => esc_html__( 'Text Limit', 'fastrans' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'fastrans' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'fastrans' ),
					'title'      => esc_html__( 'Title', 'fastrans' ),
					'menu_order' => esc_html__( 'Menu Order', 'fastrans' ),
					'rand'       => esc_html__( 'Random', 'fastrans' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'fastrans' ),
					'ASC'  => esc_html__( 'ASC', 'fastrans' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
			[
			  'type' => Controls_Manager::SELECT,
			  'label' => esc_html__('Category', 'fastrans'),
			  'label_block' => true,
			  'options' => get_faqs_categories()
			]
		);
		$this->add_control(
            'show_form_area',
			[
				'label' => __( 'Enable/Disable Form Area', 'fastrans' ),
				'type'     => Controls_Manager::SWITCHER,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enable/Disable Form Area', 'fastrans' ),
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title1',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'faq_form',
			[
				'label'       => __( 'Faqs Form Url', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Faqs Form Url', 'fastrans' ),
			]
		);
		$this->add_control(
			'feature_image',
			[
			  'label' => __( 'Feature Image', 'fastrans' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = get_query_var('paged');
		$paged = fastrans_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;
		
		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-fastrans' );
		$args = array(
			'post_type'      => 'faqs',
			'posts_per_page' => fastrans_set( $settings, 'query_number' ),
			'orderby'        => fastrans_set( $settings, 'query_orderby' ),
			'order'          => fastrans_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		
		if( fastrans_set( $settings, 'query_category' ) ) $args['faqs_cat'] = fastrans_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );

		if ( $query->have_posts()) { 
		
		$count = 1;
		$i = 1;
		$j = 1;
		$left_arr = array();
   		$right_arr = array();
					
		?>
		<?php while ( $query->have_posts() ) : $query->the_post();
				
				if($count > 2) $count = 1;
				$active = ( $query->current_post == 0 ) ? '' : 'collapsed';
				$current = ( $query->current_post == 0 ) ? 'show' : '';
			?>
			<?php if( ($count == 1)):
				$left_arr[get_the_id()] = '<div class="accordion-item headline pera-content">
												<h2 class="accordion-header" id="headingOne'.esc_attr($i).'">
													<button class="accordion-button '.$active.'" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne'.esc_attr($i).'" aria-expanded="true">
														'.get_the_title(get_the_id()).'
													</button>
												</h2>
												<div id="collapseOne'.esc_attr($i).'" class="accordion-collapse collapse '.$current.'" data-bs-parent="#accordionExample">
													<div class="accordion-body">
														'.fastrans_trim(get_the_content(), $settings['text_limit']).' 
													</div>
												</div>
											</div>';
			?>
			<?php else:
				$right_arr[get_the_id()] = '<div class="accordion-item headline pera-content">
												<h2 class="accordion-header" id="#collapseOne2'.esc_attr($j).'">
													<button class="accordion-button '.$active.'" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne2'.esc_attr($j).'" aria-expanded="true">
														'.get_the_title(get_the_id()).'
													</button>
												</h2>
												<div id="collapseOne2'.esc_attr($j).'" class="accordion-collapse collapse '.$current.'" data-bs-parent="#accordionExampl2">
													<div class="accordion-body">
														'.fastrans_trim(get_the_content(), $settings['text_limit']).' 
													</div>
												</div>
											</div>';
			?>
			<?php endif; ?>
			<?php $count++; $i++; $j++; endwhile; ?>	
            
            <!-- Start of faq  section
            ============================================= -->
            <section id="ft-faq-page" class="ft-faq-page-section page-padding">
                <div class="container">
                    <div class="ft-faq-page-top-content d-flex justify-content-between align-items-end flex-wrap">
                        <?php if($settings['title']){ ?>
                        <div class="ft-section-title-2 headline pera-content">
                            <h2><?php echo wp_kses($settings['title'], true)?></h2>
                        </div>
                        <?php } ?>
                        <?php if($settings['btn_link']['url'] and $settings['btn_title']){ ?>
                        <div class="ft-btn-3">
                            <a class="d-flex justify-content-center align-items-center" href="<?php echo esc_url($settings['btn_link']['url'])?>"><?php echo wp_kses($settings['btn_title'], true)?> <i class="flaticon-right-arrow"></i></a>
                        </div>
                        <?php } ?>
                    </div>
                    <div class="ft-faq-content">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="accordion" id="accordionExample">
                                    <?php foreach($left_arr as $key => $content):?>
										<?php echo wp_kses_post($content);?>
                                    <?php endforeach;?>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="accordion" id="accordionExampl2">
                                    <?php foreach($right_arr as $key => $right_content):?>
										<?php echo wp_kses_post($right_content);?>
                                    <?php endforeach;?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php if($settings['show_form_area']){ ?>
                    <div class="ft-faq-contact-form-wrapper">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="ft-faq-contact-form-area">
                                    <?php if( $settings['subtitle'] || $settings['title1'] ){ ?>
                                    <div class="ft-section-title-2 headline pera-content">
                                        <?php if( $settings['subtitle'] ){ ?><span class="sub-title"><?php echo wp_kses($settings['subtitle'], true)?></span><?php } ?>
                    					<?php if( $settings['title1'] ){ ?><h2><?php echo wp_kses($settings['title1'], true)?></h2><?php } ?>
                                    </div>
                                    <?php } ?>
                                    
                                    <?php echo do_shortcode($settings['faq_form'])?>
                                </div>
                            </div>
                            <?php if($settings['feature_image']['id']){ ?>
                            <div class="col-lg-6">
                                <div class="ft-faq-form-img">
                                    <img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>">
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            </section>	
        	<!-- End of faq section
            ============================================= -->
                        
        <?php }
		wp_reset_postdata();
	}

}
