<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;
/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Latest_News extends Widget_Base {
	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_latest_news';
	}
	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Latest News', 'fastrans' );
	}
	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}
	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'latest_news',
			[
				'label' => esc_html__( 'Latest News', 'fastrans' ),
			]
		);
		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'fastrans' ),
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::NUMBER,
				'default' => 4,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'fastrans' ),
					'title'      => esc_html__( 'Title', 'fastrans' ),
					'menu_order' => esc_html__( 'Menu Order', 'fastrans' ),
					'rand'       => esc_html__( 'Random', 'fastrans' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'fastrans' ),
					'ASC'  => esc_html__( 'ASC', 'fastrans' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
				[
				  'type' => Controls_Manager::SELECT,
				  'label' => esc_html__('Category', 'fastrans'),
				  'label_block' => true,
				  'options' => get_blog_categories()
				]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'blog_section_heading_style',
			[
				'label' => esc_html__( 'Heading Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'post_sec_heading_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Sub Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sub_heading_clr',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-3 span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sub_heading_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-service-innerbox-3 .ft-service-text h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'post_sec_main_heading_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'heading_clr',
			[
				'label'     => esc_html__( 'Heading Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-3 h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'heading_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-3 h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'blog_post_style',
			[
				'label' => esc_html__( 'Blog Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'post_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Post Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'post_title_clr',
			[
				'label'     => esc_html__( 'Post Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-blog-innerbox-3 .ft-blog-text h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'post_hover_title_clr',
			[
				'label'     => esc_html__( 'Post Title Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-blog-innerbox-3:hover .ft-blog-text h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'post_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-blog-innerbox-3 .ft-blog-text h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'post_meta_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Post Meta Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'post_meta_clr',
			[
				'label'     => esc_html__( 'Post Meta Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-blog-innerbox-3 .ft-blog-text .ft-blog-meta a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'post_meta_hover_clr',
			[
				'label'     => esc_html__( 'Post Meta Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-blog-innerbox-3:hover .ft-blog-text .ft-blog-meta a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'post_meta_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-blog-innerbox-3 .ft-blog-text .ft-blog-meta a',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'post_btn_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Post Button Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'post_btn_clr',
			[
				'label'     => esc_html__( 'Post Button Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-blog-innerbox-3 .ft-blog-text .more-btn' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'post_btn_hover_clr',
			[
				'label'     => esc_html__( 'Post Button Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-blog-innerbox-3 .ft-blog-text .more-btn:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'post_btn_hover_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-blog-innerbox-3 .ft-blog-text .more-btn',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
	}
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = get_query_var('paged');
		$paged = fastrans_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;
		
		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-fastrans' );
		$args = array(
			'post_type'      => 'post',
			'posts_per_page' => fastrans_set( $settings, 'query_number' ),
			'orderby'        => fastrans_set( $settings, 'query_orderby' ),
			'order'          => fastrans_set( $settings, 'query_order' ),
			'paged'          => $paged
		);
		
		if( fastrans_set( $settings, 'query_category' ) ) $args['category_name'] = fastrans_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );
		
		if ( $query->have_posts() ) 
		{ ?>

        <!-- Start of Blog section
        ============================================= -->
        <section id="ft-blog-3" class="ft-blog-section-3">
            <div class="container">
                <?php if($settings['sub_title'] || $settings['title']){ ?>
                <div class="ft-section-title-3 headline text-center">
                    <?php if($settings['sub_title']){ ?><span class="text-uppercase"><?php echo wp_kses($settings['sub_title'], true); ?></span><?php } ?>
                    <?php if($settings['title']){ ?><h2><?php echo wp_kses($settings['title'], true); ?></h2><?php } ?>
                </div>
                <?php } ?>
                <div class="ft-blog-content-3">
                    <div class="blog-slider-3">
                        <?php while ( $query->have_posts() ) : $query->the_post(); ?>
                        <div class="ft-item-innerbox">
                            <div class="ft-blog-innerbox-3 position-relative">
                                <div class="ft-blog-img">
                                    <?php the_post_thumbnail('fastrans_375x254'); ?>
                                </div>
                                <div class="ft-blog-text headline pera-content position-relative">
                                    <div class="ft-blog-meta d-flex justify-content-between">
                                        <a href="<?php echo get_month_link(get_the_date('Y'), get_the_date('m')); ?>"><i class="fas fa-calendar-alt"></i> <?php echo esc_attr(get_the_date()); ?></a>
                                        <a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta('ID') )); ?>"><i class="fas fa-user"></i> <?php the_author(); ?></a>
                                    </div>
                                    <h3><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></h3>
                                    <a class="more-btn text-uppercase d-flex justify-content-center align-items-center position-absolute" href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php esc_html_e('Read More', 'fastrans'); ?></a>
                                </div>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>
                </div>
            </div>
        </section>		
    	<!-- End of Blog section
        ============================================= -->
                
		<?php }
		wp_reset_postdata();
	}
}