<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class About_Us_V3 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_about_us_v3';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'About Us V3', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'about_us_v3',
				[
					'label' => esc_html__( 'About Us V3', 'fastrans' ),
				]
		);
		$this->add_control(
			'about_image',
			[
			  'label' => __( 'About Image', 'fastrans' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your text', 'fastrans' ),
			]
		);
		$this->add_control(
            'services', 
			  	[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
				[
					['block_title' => esc_html__('Our Mission', 'fastrans')],
					['block_title' => esc_html__('Our Vision', 'fastrans')]
				],
			'fields' => 
				[
					[
						'name' => 'icons',
						'label' => esc_html__('Enter The icons', 'fastrans'),
						'label_block' => true,
						'type' => Controls_Manager::SELECT2,
						'options'  => get_fontawesome_icons(),
					],
					[
						'name' => 'block_title',
						'label' => esc_html__('Title', 'fastrans'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('', 'fastrans')
					],
					[
						'name' => 'block_text',
						'label' => esc_html__('Description', 'fastrans'),
						'label_block' => true,
						'type' => Controls_Manager::TEXTAREA,
						'default' => esc_html__('', 'fastrans')
					],
				],
				'title_field' => '{{block_title}}',
            ]
        );
		$this->add_control(
			'btn_title',
			[
				'label'       => __( 'Button Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title', 'fastrans' ),
			]
		);
		$this->add_control(
            'btn_link',
			[
				'label' => __( 'Button Url', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		$this->end_controls_section();
		$this->start_controls_section(
			'about_heading_style',
			[
				'label' => esc_html__( 'About Heading Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'service_sub_hd_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Sub Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sub_title_clr',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-2 .sub-title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sub_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-2 .sub-title',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'service_hd_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-2 h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-2 h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'color_hd_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Color Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'clr_title_clr',
			[
				'label'     => esc_html__( 'Color Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-2 h2 span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'clr_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-2 h2 span',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'ab_text_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Text Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'ab_text_clr',
			[
				'label'     => esc_html__( 'Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-2.pera-content p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'ab_text_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-2.pera-content p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'mision_vision_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Mission Vision Title', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'mv_titlet_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-about-feature-list-item .ft-about-feature-text h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'mv_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-about-feature-list-item .ft-about-feature-text h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
			);
		$this->add_control(
			'mision_vision_text_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Mission Vision Text', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'mv_text_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-about-feature-text.headline.pera-content p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'mv_text_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-about-feature-text.headline.pera-content p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>
	
    <!-- Start of About section
	============================================= -->
	<section id="ft-about-2" class="ft-about-section-2">
		<div class="container">
			<div class="ft-about-content-2">
				<div class="row">
					<div class="col-lg-6">
						<div class="ft-about-text-wrapper-2">
							<?php if( $settings['subtitle'] || $settings['title'] || $settings['text'] ){ ?>
                            <div class="ft-section-title-2 headline pera-content">
								<?php if( $settings['subtitle'] ){ ?><span class="sub-title"><?php echo wp_kses($settings['subtitle'], true)?></span><?php } ?>
								<?php if( $settings['title'] ){ ?><h2><?php echo wp_kses($settings['title'], true)?></h2><?php } ?>
								<?php if( $settings['text'] ){ ?><p><?php echo wp_kses($settings['text'], true)?> </p><?php } ?>
                            </div>
							<?php } ?>
                            <div class="ft-about-feature-wrapper-2">
								<div class="row">
									<?php foreach($settings['services'] as $key => $item): ?>
                                    <div class="col-lg-6">
										<div class="ft-about-feature-list-item d-flex align-items-center">
											<div class="ft-about-feature-icon d-flex align-items-center justify-content-center">
												<i class="fa <?php echo esc_attr(str_replace( "fa ",  "", $item['icons']));?>"></i>
											</div>
											<div class="ft-about-feature-text headline pera-content">
												<h3><?php echo esc_attr($item['block_title']);?></h3>
												<p><?php echo esc_attr($item['block_text']);?></p>
											</div>
										</div>
									</div>
                                    <?php endforeach; ?>
								</div>
                                <?php if( $settings['btn_title'] and $settings['btn_link']['url'] ){ ?>
								<div class="ft-btn-3">
									<a class="d-flex justify-content-center align-items-center" href="<?php echo esc_url($settings['btn_link']['url']); ?>"><?php echo wp_kses($settings['btn_title'], true); ?> <i class="flaticon-right-arrow"></i></a>
								</div>
                                <?php } ?>
							</div>
						</div>
					</div>
					<?php if($settings['about_image']['id']){ ?>
                    <div class="col-lg-6">
						<div class="ft-about-img-2-wrapper position-relative">
							<span class="ft-about-shape1 position-absolute"><img src="<?php echo esc_url(get_template_directory_uri());?>/assets/images/shape/ab-sh1.png" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>"></span>
							<span class="ft-about-shape2 position-absolute"><img src="<?php echo esc_url(get_template_directory_uri());?>/assets/images/shape/ab-sh2.png" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>"></span>
							<div class="ft-about-img-2">
								<img src="<?php echo esc_url(wp_get_attachment_url($settings['about_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>">
							</div>
						</div>
					</div>
                    <?php } ?>
				</div>
			</div>
		</div>
	</section>
	<!-- End of About section
	============================================= -->
    
    <?php 
	
	}

}