<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Transport_Service extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_transport_service';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Transport Service', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'transport_service',
			[
				'label' => esc_html__( 'Our Service V6', 'fastrans' ),
			]
		);
		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'service_id', [
                'label'       => esc_html__( 'Select service', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'options'     => $this->select_param_posts(),
            ]
        );

        $repeater->add_control(
            'hr',
            [
                'type'  => \Elementor\Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );
        

        $repeater->add_control(
            'service_img',
            [
                'label' => esc_html__( 'service Icon', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'service_info', [
                'label'       => esc_html__( 'Service Short Description', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'service_hover_info', [
                'label'       => esc_html__( 'Service Hover Short Description', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'service_icon', [
                'label'       => esc_html__( 'Service Icon Name', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'service_btn_txt', [
                'label'       => esc_html__( 'Readmore Button Label', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'service_boxes',
            [
                'label'       => __( 'Add Item', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
            ]
        );
		$this->end_controls_section();
		$this->start_controls_section(
			'services_style',
			[
				'label' => esc_html__( 'service Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'ser_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'title_typography',
                'label'          => esc_html__( 'Typography', 'prysm' ),
                'selector'       => '{{WRAPPER}} .service-block-three .inner-box h5',
                'fields_options' => [
                    'font_family' => [
                        'default' => 'Poppins',
                    ],
					'font_weight' => [
                        'default' => '700',
                    ],
                    'font_size'   => [
                        'default' => [
                            'size' => '22',
                        ],
                    ],
                ],
            ]
        );
		$this->add_control(
			'ser_hovb_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Title Hover Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'title-h_typography',
                'label'          => esc_html__( 'Typography', 'prysm' ),
                'selector'       => '{{WRAPPER}} .service-block-three .overlay-inner h5',
                'fields_options' => [
                    'font_family' => [
                        'default' => 'Poppins',
                    ],
					'font_weight' => [
                        'default' => '700',
                    ],
                    'font_size'   => [
                        'default' => [
                            'size' => '22',
                        ],
                    ],
                ],
            ]
        );
		$this->end_controls_section();
	}
	
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$service_boxes = $settings['service_boxes'];
        
        ?>

        <!-- Services Section Four -->
		<section class="services-section-four">
			<div class="auto-container">
				<div class="inner-container">
					<div class="clearfix">
                    <?php $shape = 0; foreach($service_boxes as $index => $box): $shape++;?>
                    <?php  if( $box['service_id'] ) : ?>
						
						<!-- Service Block Three -->
						<div class="service-block-three col-lg-4 col-md-6 col-sm-12">
							<div class="inner-box">
								<div class="image-layer" style="background-image:url(<?php echo esc_url($box['service_img']['url']);?>)"></div>
								<h5><a href="<?php echo esc_url(get_post_meta( $box['service_id'], 'service_url', true ));?> "><?php echo get_the_title($box['service_id']);?></a></h5>
								<div class="text"><?php echo esc_html($box['service_info']);?></div>
								<a href="<?php echo esc_url(get_post_meta( $box['service_id'], 'service_url', true ));?> " class="read-more"><?php echo esc_html($box['service_btn_txt']);?></a>
								
								<!-- Overlay Box -->
								<div class="overlay-box">
									<div class="overlay-image-layer" style="background-image:url(<?php echo esc_url($box['service_img']['url']);?>)"></div>
									<div class="shape-layer"></div>
									<div class="overlay-inner">
										<div class="content">
											<div class="icon-box">
												<span class="icon <?php echo esc_attr($box['service_icon']);?>"></span>
											</div>
											<h5><a href="<?php echo esc_url(get_post_meta( $box['service_id'], 'service_url', true ));?> "><?php echo get_the_title($box['service_id']);?></a></h5>
											<div class="lower-text"><?php echo __($box['service_hover_info']);?></div>
											<a href="<?php echo esc_url(get_post_meta( $box['service_id'], 'service_url', true ));?>" class="more"><?php echo esc_html($box['service_btn_txt']);?> <span class="fa fa-angle-right"></span></a>
										</div>
									</div>
								</div>
								
							</div>
						</div>
						<?php endif; endforeach;?>
					</div>
				</div>
			</div>
		</section>
		<!-- End Services Section Four -->

        <?php 
	}
    protected function select_param_posts() {
        $args = wp_parse_args( [
            'post_type'   => 'service',
            'numberposts' => -1,
            'orderby'     => 'title',
            'order'       => 'ASC',
        ] );
    
        $query_query = get_posts( $args );
    
        $posts = [];
        if ( $query_query ) {
            foreach ( $query_query as $query ) {
                $posts[$query->ID] = $query->post_title;
            }
        }
    
        return $posts;
    }
}