<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Transport_About extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrance_transport_about';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Transport About', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'transport_slider',
			[
				'label' => esc_html__( 'Slider Option', 'fastrans' ),
			]
		);
        $this->add_control(
			'sub_heading', [
				'label'       => esc_html__( 'Sub Heading', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'heading', [
				'label'       => esc_html__( 'Heading', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'description', [
				'label'       => esc_html__( 'Description', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);
        $this->add_control(
			'middle_content',
			[
				'label' => esc_html__( 'Middle Content', 'fastrans' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'about_img',
			[
				'label' => esc_html__( 'About Image', 'plugin-name' ),
				'type' => Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'number', [
				'label'       => esc_html__( 'Number', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'about_content', [
				'label'       => esc_html__( 'About Content', 'fastrans' ),
				'type'        => Controls_Manager::WYSIWYG,
				'label_block' => true,
			]
		);
		$this->add_control(
			'btn_content', [
				'label'       => esc_html__( 'Button Label', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link', [
				'label'       => esc_html__( 'Button Link', 'fastrans' ),
				'type'        => Controls_Manager::URL,
				'label_block' => true,
			]
		);
		$this->add_control(
			'btm_content', [
				'label'       => esc_html__( 'Bottom Content', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);	
		
		$this->end_controls_section();
		$this->start_controls_section(
			'about_style',
			[
				'label' => esc_html__( 'About Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'btm_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Bottom Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'btmtitle-h_typography',
                'label'          => esc_html__( 'Typography', 'prysm' ),
                'selector'       => '{{WRAPPER}} .about-section .lower-box h4',
                'fields_options' => [
                    'font_family' => [
                        'default' => 'Poppins',
                    ],
					'font_weight' => [
                        'default' => '700',
                    ],
                    'font_size'   => [
                        'default' => [
                            'size' => '24',
                        ],
                    ],
                ],
            ]
        );
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display(); 
        $sub_heading = $settings['sub_heading'];
        $heading     = $settings['heading'];
        $description     = $settings['description'];
        $about_img     = $settings['about_img']['url'];
        $number     = $settings['number'];
        $title     = $settings['title'];
        $about_content     = $settings['about_content'];
        $btn_content     = $settings['btn_content'];
        $btn_link     = $settings['btn_link'];
        $btm_content     = $settings['btm_content'];
    ?>
    <!-- About Section -->
		<section class="about-section">
			<div class="auto-container">
				<div class="row clearfix">
				
					<!-- Title Column -->
					<div class="title-column col-lg-4 col-md-6 col-sm-12">
						<div class="inner-column">
							<div class="sec-title-two style-two">
								<div class="title"><?php echo esc_html($sub_heading);?></div>
								<h2><?php echo esc_html($heading);?></h2>
							</div>
							<div class="text"><?php echo __($description);?></div>
						</div>
					</div>
					
					<!-- Image Column -->
					<div class="image-column col-lg-4 col-md-12 col-sm-12">
						<div class="inner-column">
							<div class="image">
								<img src="<?php echo esc_url($about_img);?>" alt="" />
								<div class="client-box">
									<span class="icon flaticonv2-team"></span>
									<div class="count-outer count-box">
										<span class="count-text counter"><?php echo esc_attr($number);?></span>+
									</div>
									<div class="counter-title"><?php echo esc_html($title);?></div>
								</div>
							</div>
						</div>
					</div>
					
					<!-- Content Column -->
					<div class="content-column col-lg-4 col-md-6 col-sm-12">
						<div class="inner-column">
							<div class="text">
								<?php echo __($about_content);?>
							</div>
							<a href="<?php echo esc_url($btn_link['url']);?>" class="learn-more"><?php echo esc_html($btn_content);?></a>
						</div>
					</div>
					
				</div>
				
				<!-- Lower Box -->
				<div class="lower-box text-center">
					<h4><?php echo __($btm_content);?></h4>
				</div>
				
			</div>
		</section>
		<!-- End About Section -->
	<?php	
	}

}
