<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Service_V7 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'service_v7';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Service V7', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-gallery-justified';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'service_section',
				[
					'label' => esc_html__( 'Service Section', 'fastrans' ),
				]
		);
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__( 'Sub Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'We Specialse In The Transportation', 'fastrans' ),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'We are optimists who Love
to work Together.', 'fastrans' ),
            ]
        );
        $this->add_control(
            'services_btn_text',
            [
                'label' => esc_html__( 'Button Text', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'More Service', 'fastrans' ),
            ]
        );
        $this->add_control(
            'services_url',
            [
                'label' => esc_html__( 'Link', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'fastrans' ),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
            ]
        );
		$this->end_controls_section();
        $this->start_controls_section(
            'service_content_serction',
            [
                'label' => __( 'Service Conternt', 'appilo' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'heading', [
                'label' => esc_html__( 'Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'AIR TRANSPORT' , 'fastrans' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'info', [
                'label' => esc_html__( 'Info', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'How all this mistaken idea of denouncing pleasure and praising ...' , 'fastrans' ),
                'show_label' => false,
            ]
        );

        $repeater->add_control(
            'service_btn', [
                'label' => esc_html__( 'Service Button', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Explore More' , 'fastrans' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'single_service_btn_url',
            [
                'label' => esc_html__( 'Link', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'fastrans' ),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
            ]
        );
        $repeater->add_control(
            'image',
            [
                'label' => esc_html__( 'Choose Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'btn_active',
            [
                'label' => esc_html__( 'Button Active', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'fastrans' ),
                'label_off' => esc_html__( 'Hide', 'fastrans' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'single_service',
            [
                'label' => esc_html__( 'Service List', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'heading' => esc_html__( 'AIR TRANSPORT', 'fastrans' ),
                    ],
                    [
                        'heading' => esc_html__( 'ROAD TRANSPORT', 'fastrans' ),
                    ],
                    [
                        'heading' => esc_html__( 'AIR TRANSPORT', 'fastrans' ),
                    ],
                    [
                        'heading' => esc_html__( 'ROAD TRANSPORT', 'fastrans' ),
                    ],
                ],

            ]
        );


        $this->end_controls_section();

		$this->start_controls_section(
			'service_section_style',
			[
				'label' => esc_html__( 'Service Section Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'sub_title_color',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title .title' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => 'Sub Title Typography',
                'selector' => '{{WRAPPER}} .sec-title .title',
            ]
        );
		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title h2' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => 'Title Typography',
                'selector' => '{{WRAPPER}} .sec-title h2',
            ]
        );
		$this->add_control(
			'btn_color',
			[
				'label'     => esc_html__( 'Button Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a.theme-btn.btn-style-one' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .btn-style-one .icon' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'btn_bg_color',
			[
				'label'     => esc_html__( 'Button BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-one' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'btn_icon_bg_color',
			[
				'label'     => esc_html__( 'Button Icon BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-one .icon' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'btn_typo',
				'label'          => esc_html__( 'Button Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .btn-style-one',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
        $this->add_control(
            'btn_hover__color__',
            [
                'label'     => esc_html__( 'Button Hover Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-one:hover' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .btn-style-one:hover .icon' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'btn_hover_BG_color',
            [
                'label'     => esc_html__( 'Button Hover BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-one:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_hover_icon_BG_color',
            [
                'label'     => esc_html__( 'Button Hover Icon BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-one:hover .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();
        $this->start_controls_section(
            '_service_content_style',
            [
                'label' => __( 'Service Content Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            '_content-title',
            [
                'label'     => esc_html__( 'Content Title Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-block .inner-box h4 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            '_content-title-hover_color',
            [
                'label'     => esc_html__( 'Content Title Hover Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-block .inner-box h4 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => '_content_title_typography',
                'label'          => esc_html__( 'Content Title Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .service-block .inner-box h4 a',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
        $this->add_control(
            '_content_info_color',
            [
                'label'     => esc_html__( 'Info Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-block .inner-box .text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => '_content_info_typography',
                'label'          => esc_html__( 'Content Info Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .service-block .inner-box .text',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
        $this->add_control(
            '__service_content_single_btn_style',
            [
                'label' => esc_html__( 'Single Service Button Style', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            '_single_btn_color',
            [
                'label'     => esc_html__( 'Button Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} a.theme-btn.btn-style-three' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .btn-style-three .icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            '_single_btn_bg_color',
            [
                'label'     => esc_html__( 'Button BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            '_single_btn_icon_bg_color',
            [
                'label'     => esc_html__( 'Button Icon BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => '_signel_btn_typo',
                'label'          => esc_html__( 'Button Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .btn-style-three',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
        $this->add_control(
            '_single_btn_hover__color__',
            [
                'label'     => esc_html__( 'Button Hover Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three:hover' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .btn-style-three:hover .icon' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            '_single_btn_hover_BG_color',
            [
                'label'     => esc_html__( 'Button Hover BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            '_single_btn_hover_icon_BG_color',
            [
                'label'     => esc_html__( 'Button Hover Icon BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn-style-three:hover .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();

	?>

        <!-- Services Section -->
        <div class="services-section">
            <div class="auto-container">
                <div class="sec-title">
                    <div class="clearfix">
                        <div class="pull-left">
                            <div class="title"><?php echo $settings['sub_title']; ?></div>
                            <h2><?php echo $settings['title']; ?></h2>
                        </div>
                        <div class="pull-right">
                            <!-- Btn Box -->
                            <div class="btn-box">
                                <a href="<?php echo $settings['services_url']['url']; ?>" class="theme-btn btn-style-one"><?php echo $settings['services_btn_text']; ?> <span class="icon fas fa-angle-double-right"></span></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="service-carousel-two owl-carousel owl-theme">

                    <!-- Service Block -->
                    <?php
                        foreach ($settings['single_service'] as $list):
                    ?>
                    <div class="service-block">
                        <div class="inner-box">
                            <div class="content">
                                <h4><a href="<?php echo $list['single_service_btn_url']['url']; ?>"><?php echo $list['heading']; ?></a></h4>
                                <div class="text"><?php echo $list['info']; ?></div>
                                <!-- Btn Box -->
                                <div class="btn-box">
                                    <a href="<?php echo $list['single_service_btn_url']['url']; ?>" class="theme-btn <?php if ('yes' == $list['btn_active']){ echo "btn-style-one"; }else{ echo "btn-style-three"; } ?>"><?php echo $list['service_btn']; ?> <span class="icon fas fa-angle-double-right"></span></a>
                                </div>
                            </div>
                            <div class="side-icon">
                                <img src="<?php echo $list['image']['url'];?>" alt="" />
                            </div>
                            <div class="color-layer"></div>
                        </div>
                    </div>

                    <?php endforeach; ?>


                </div>
            </div>
        </div>
        <!-- End Services Section -->

    <?php 
	
	}

}