<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Services extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_our_services';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Services', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'our_services',
			[
				'label' => esc_html__( 'Our Services', 'fastrans' ),
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'fastrans' ),
			]
		);
		$this->add_control(
			'text_limit',
			[
				'label'   => esc_html__( 'Text Limit', 'fastrans' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'fastrans' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'fastrans' ),
					'title'      => esc_html__( 'Title', 'fastrans' ),
					'menu_order' => esc_html__( 'Menu Order', 'fastrans' ),
					'rand'       => esc_html__( 'Random', 'fastrans' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'fastrans' ),
					'ASC'  => esc_html__( 'ASC', 'fastrans' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
			[
			  'type' => Controls_Manager::SELECT,
			  'label' => esc_html__('Category', 'fastrans'),
			  'label_block' => true,
			  'options' => get_service_categories()
			]
		);
		$this->add_control(
            'show_bottom_info',
			[
				'label' => __( 'Enable/Disable Bottom Info Area', 'fastrans' ),
				'type'     => Controls_Manager::SWITCHER,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enable/Disable Bottom Info Area', 'fastrans' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'text', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Section Bottom Description', 'fastrans' ),
			]
		);
		$this->add_control(
			'btn_title',
			[
				'label'       => __( 'Button Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title', 'fastrans' ),
			]
		);
		$this->add_control(
            'btn_link',
			[
				'label' => __( 'Button Url', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'fastrans' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		$this->end_controls_section();
		$this->start_controls_section(
			'service_heading_style',
			[
				'label' => esc_html__( 'Section Heading Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'service_sub_hd_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Sub Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sub_title_clr',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-3 span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sub_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-3 span',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'service_hd_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-3 h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-3 h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'service_style',
			[
				'label' => esc_html__( 'Service Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'service_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'service_title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-service-innerbox-3 .ft-service-text h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'service_hover_title_clr',
			[
				'label'     => esc_html__( 'Title Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-service-innerbox-3:hover .ft-service-text h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'serv_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-service-innerbox-3 .ft-service-text h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'service_excerpt_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Excerpt Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'service_excerpt_clr',
			[
				'label'     => esc_html__( 'Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-service-innerbox-3 .ft-service-text p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'service_hover_excerpt_clr',
			[
				'label'     => esc_html__( 'Text Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-service-innerbox-3:hover .ft-service-text p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'serv_text_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-service-innerbox-3 .ft-service-text p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'service_btn_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Button Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'service_btn_clr',
			[
				'label'     => esc_html__( 'Button Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-service-innerbox-3 .more-btn a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'btn_hover_clr',
			[
				'label'     => esc_html__( 'Button Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-service-innerbox-3 .more-btn a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'ser_btn_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-service-innerbox-3 .more-btn a',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = get_query_var('paged');
		$paged = fastrans_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-fastrans' );
		$args = array(
			'post_type'      => 'service',
			'posts_per_page' => fastrans_set( $settings, 'query_number' ),
			'orderby'        => fastrans_set( $settings, 'query_orderby' ),
			'order'          => fastrans_set( $settings, 'query_order' ),
			'paged'          => $paged
		);
		
		if( fastrans_set( $settings, 'query_category' ) ) $args['service_cat'] = fastrans_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );

		if ( $query->have_posts() ) 
		{ ?>
		
        <!-- Start of Service section
        ============================================= -->
        <section id="ft-service-3" class="ft-service-section-3">
            <div class="container">
                <?php if( $settings['subtitle'] || $settings['title'] ){ ?>
                <div class="ft-section-title-3 headline text-center">
                    <?php if( $settings['subtitle'] ){ ?><span class="text-uppercase"><?php echo wp_kses($settings['subtitle'], true)?></span><?php } ?>
                    <?php if( $settings['title'] ){ ?><h2><?php echo wp_kses($settings['title'], true)?></h2><?php } ?>
                </div>
                <?php } ?>
                <div class="ft-service-content-3">
                    <div class="ft-service-content-items-3">
                        <div class="row justify-content-center">
                            <?php while ( $query->have_posts() ) : $query->the_post(); ?>
                            <div class="col-lg-4 col-md-6">
                                <div class="ft-service-innerbox-3 position-relative">
                                    <?php if(has_post_thumbnail()){ ?>
                                    <div class="ft-service-img position-relative">
                                        <?php the_post_thumbnail('fastrans_370x290'); ?>
                                    </div>
                                    <?php } ?>
                                    <div class="ft-service-text-icon position-relative">
                                        <div class="ft-service-icon d-flex align-items-center justify-content-center position-absolute">
                                            <i class="<?php echo wp_kses(str_replace( "icon ",  "",  get_post_meta(get_the_id(), 'service_icon', true )), $allowed_tags); ?>"></i>
                                        </div>
                                        <div class="ft-service-text position-relative headline pera-content">
                                            <h3><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'service_url', true ));?>"><?php the_title(); ?></a></h3>
                                            <p><?php echo wp_kses(fastrans_trim(get_the_content(), $settings['text_limit']), true); ?></p>
                                        </div>
                                    </div>
                                    <div class="more-btn position-absolute">
                                        <a class="d-flex align-items-center justify-content-center text-uppercase" href="<?php echo esc_url(get_post_meta( get_the_id(), 'service_url', true ));?>"><?php esc_html_e('Read more', 'fastrans'); ?> <i class="far fa-arrow-right"></i></a>
                                    </div>
                                </div>
                            </div>
                            <?php endwhile; ?>
                        </div>
                    </div>
                    <?php if($settings['show_bottom_info']){ ?>
                    <div class="ft-service-more-btn d-flex flex-wrap justify-content-center align-items-center">
                        <?php if($settings['text']){ ?><span><?php echo wp_kses($settings['text'], true)?></span><?php } ?>
                        <?php if($settings['btn_link']['url'] and $settings['btn_title']){ ?><a class="text-uppercase align-items-center justify-content-center d-flex" href="<?php echo esc_url($settings['btn_link']['url'])?>" target="_blank"><?php echo wp_kses($settings['btn_title'], true)?></a><?php } ?>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </section>
    	<!-- End of Service section
        ============================================= -->
                    
        <?php }
		wp_reset_postdata();
	}
}