<?php namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Latest_News_V3 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'fastrans_latest_news_v3';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Latest News V3', 'fastrans' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'fastrans' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'latest_news_v3',
            [
                'label' => esc_html__( 'General', 'fastrans' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'fastrans' ),
			]
		);
		$this->add_control(
			'text_limit',
			[
				'label'   => esc_html__( 'Text Limit', 'fastrans' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'fastrans' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 4,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'fastrans' ),
					'title'      => esc_html__( 'Title', 'fastrans' ),
					'menu_order' => esc_html__( 'Menu Order', 'fastrans' ),
					'rand'       => esc_html__( 'Random', 'fastrans' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'fastrans' ),
					'ASC'  => esc_html__( 'ASC', 'fastrans' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
				[
				  'type' => Controls_Manager::SELECT,
				  'label' => esc_html__('Category', 'fastrans'),
				  'label_block' => true,
				  'options' => get_blog_categories()
				]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'blog_stylw',
			[
				'label' => esc_html__( 'Blog Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'blog_title',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Blog Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'blog_title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-blog-innerbox-2 .ft-blog-text-2 h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'blog_title_hover_clr',
			[
				'label'     => esc_html__( 'Title Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-blog-innerbox-2:hover .ft-blog-text-2 h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-blog-innerbox-2 .ft-blog-text-2 h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'blog_excerpt',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Blog Excerpt Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'blog_excerpt_clr',
			[
				'label'     => esc_html__( 'Excerpt Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-blog-innerbox-2 .ft-blog-text-2 p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'blog_excerpt_hover_clr',
			[
				'label'     => esc_html__( 'Title Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-blog-innerbox-2:hover .ft-blog-text-2 p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'excerpt__typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-blog-innerbox-2 .ft-blog-text-2 p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'blog_date',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Blog Date Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'blog_date_clr',
			[
				'label'     => esc_html__( 'Date Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-blog-innerbox-2 .ft-blog-meta' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'blog_date_bg_clr',
			[
				'label'     => esc_html__( 'Date BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-blog-innerbox-2 .ft-blog-meta' => 'background: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'date__typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-blog-innerbox-2 .ft-blog-meta',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'blog_readmore_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Readmore Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'blog_readmore_clr',
			[
				'label'     => esc_html__( 'Readmore Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-btn-2 a' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'readmore__typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-btn-2 a',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
	}
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = get_query_var('paged');
		$paged = fastrans_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;
		
		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-fastrans' );
		$args = array(
			'post_type'      => 'post',
			'posts_per_page' => fastrans_set( $settings, 'query_number' ),
			'orderby'        => fastrans_set( $settings, 'query_orderby' ),
			'order'          => fastrans_set( $settings, 'query_order' ),
			'paged'          => $paged
		);
		
		if( fastrans_set( $settings, 'query_category' ) ) $args['category_name'] = fastrans_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );
		
		if ( $query->have_posts() ) 
		{ ?>

        <!-- Start of blog  section
        ============================================= -->
        <section id="ft-blog-2" class="ft-blog-section-2 position-relative">
            <div class="container">
                <?php if($settings['sub_title'] || $settings['title']){ ?>
                <div class="ft-section-title-2 headline pera-content text-center">
                    <?php if($settings['sub_title']){ ?><span class="sub-title"><?php echo wp_kses($settings['sub_title'], true); ?></span><?php } ?>
                    <?php if($settings['title']){ ?><h2><?php echo wp_kses($settings['title'], true); ?></h2><?php } ?>
                </div>
                <?php } ?>
                <div class="ft-blog-content-2">
                    <div class="ft-blog-slider-2">
                        <?php while ( $query->have_posts() ) : $query->the_post(); ?>
                        <div class="ft-item-innerbox">
                            <div class="ft-blog-innerbox-2">
                                <?php if(has_post_thumbnail()){ ?>
                                <div class="ft-blog-img-2 position-relative">
                                    <?php the_post_thumbnail('fastrans_370x230'); ?>
                                    <div class="ft-blog-meta text-center d-flex align-items-center justify-content-center position-absolute">
                                        <?php echo esc_attr(get_the_date('d M')); ?>
                                    </div>
                                </div>
                                <?php } ?>
                                <div class="ft-blog-text-2 headline pera-content">
                                    <h3><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></h3>
                                    <p><?php echo wp_kses(fastrans_trim(get_the_content(), $settings['text_limit']), true); ?> </p>
                                    <div class="ft-btn-2">
                                        <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>">
                                            <i class="icon-first flaticon-right-arrow"></i>
                                            <span><?php esc_html_e('Read More', 'fastrans'); ?></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>
                    <div class="carousel_nav  clearfix">
                        <button type="button" class="blg-left_arrow"><i class="fa fa-arrow-left"></i></button>
                        <button type="button" class="blg-right_arrow"><i class="fa fa-arrow-right"></i></button>
                    </div>
                </div>
            </div>
        </section>
    	<!-- End of blog  section
        ============================================= -->
                        
		<?php }
		wp_reset_postdata();
	}
}