<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Global_Location_V7 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'global_location_v7';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Global Location V7', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return ' eicon-form-horizontal';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'global_location_section',
				[
					'label' => esc_html__( 'Global Location Section', 'fastrans' ),
				]
		);
        $this->add_control(
            'title_box',
            [
                'label' => esc_html__( 'Box Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Global Location', 'fastrans' ),
            ]
        );
		$this->end_controls_section();

        $this->start_controls_section(
            'global_location_details',
            [
                'label' => __( 'Location Info', 'fastrans' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'United Kingdom- Head Office', 'fastrans' ),
            ]
        );
        $repeater->add_control(
            'office_icon',
            [
                'label' => esc_html__( 'Office Icon', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );
        $repeater->add_control(
            'office',
            [
                'label' => esc_html__( 'Office', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__( '3499 Sigley Road, Belleville, KS 66935, UK', 'fastrans' ),
            ]
        );
        $repeater->add_control(
            'mail_icon',
            [
                'label' => esc_html__( 'Mail Icon', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );
        $repeater->add_control(
            'email',
            [
                'label' => esc_html__( 'Email', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__( 'fastrans@gmail.com', 'fastrans' ),
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__( 'Item List', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => esc_html__( 'United Kingdom- Head Office', 'fastrans' ),
                    ],[
                        'title' => esc_html__( 'United States- 2nd Office', 'fastrans' ),
                    ],[
                        'title' => esc_html__( 'Canada- 3rd Office', 'fastrans' ),
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'global_location_style',
			[
				'label' => esc_html__( 'Section Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'section_bg_color',
			[
				'label'     => esc_html__( 'Background Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .location-section .inner-container' => 'background-color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
            'section_bg',
            [
                'label' => esc_html__( 'Section Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
		$this->add_control(
			'box_title_color',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .location-section .title-box h4' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'title_typography',
                'label'          => esc_html__( 'Title Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .location-section .title-box h4',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
		$this->end_controls_section();

        $this->start_controls_section(
            'location_box_style',
            [
                'label' => __( 'Location Info Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'location_title_color',
            [
                'label'     => esc_html__( 'Location Title Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .location-section h6' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'location_itle_typography',
                'label'          => esc_html__( 'Location Title Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .location-section h6',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label'     => esc_html__( 'Icon Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .location-section .post-info li .icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color',
            [
                'label'     => esc_html__( 'Icon BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .location-section .post-info li .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'location_info_color',
            [
                'label'     => esc_html__( 'Location Info Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .location-section .post-info li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'location_info_typography',
                'label'          => esc_html__( 'Location Info Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .location-section .post-info li',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
        $this->end_controls_section();

	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();

	?>

        <!-- Location Section -->
        <section class="location-section">
            <div class="auto-container">
                <div class="inner-container" style="background-image:url(<?php echo $settings['section_bg']['url']; ?>)">
                    <div class="title-box">
                        <h4><?php echo $settings['title_box']; ?></h4>
                    </div>
                    <div class="row clearfix">

                        <?php foreach ($settings['items'] as $item): ?>

                        <!-- Column -->
                        <div class="column col-lg-4 col-md-6 col-sm-12">
                            <h6><?php echo $item['title']; ?></h6>
                            <ul class="post-info">
                                <li><span class="icon">
                                    <?php \Elementor\Icons_Manager::render_icon( $item['office_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </span><?php echo $item['office']; ?>
                                </li>
                                <li><span class="icon">
                                    <?php \Elementor\Icons_Manager::render_icon( $item['mail_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </span><?php echo $item['email']; ?>
                                </li>
                            </ul>
                        </div>

                        <?php endforeach; ?>

                    </div>
                </div>
            </div>
        </section>
        <!-- End Location Section -->

    <?php 
	
	}

}