<?php

/**
 * Blog Content Template
 *
 * @package    WordPress
 * @subpackage FASTRANS
 * @author     Themexriver
 * @version    1.0
 */

if ( class_exists( 'Fastrans_Resizer' ) ) {
	$img_obj = new Fastrans_Resizer();
} else {
	$img_obj = array();
}

$options = fastrans_WSH()->option();

$allowed_tags = wp_kses_allowed_html('post');
global $post;
?>
<div <?php post_class(); ?>>
	
    <div class="ft-blog-post-feed-innerbox">
        <?php if(has_post_thumbnail()){ ?>
        <div class="ft-blog-post-feed-img">
            <?php the_post_thumbnail('fastrans_1170x440'); ?>
        </div>
        <?php } ?>
        <div class="ft-blog-post-feed-text-wrapper headline pera-content">
            <div class="blog-meta">
                <?php if( $options->get( 'blog_post_author' ) ){ ?><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta('ID') )); ?>"><i class="fas fa-user"></i> <?php esc_html_e('By', 'fastrans'); ?> <?php the_author(); ?></a><?php } ?>
                <?php if( $options->get( 'blog_post_date' ) ){ ?><a href="<?php echo get_month_link(get_the_date('Y'), get_the_date('m')); ?>"><i class="fas fa-calendar"></i> <?php echo esc_attr(get_the_date()); ?></a><?php } ?>
                <?php if(has_category()){ ?><i class="fas fa-tag"></i> <?php the_category(', '); ?><?php } ?>
            </div>
            <div class="ft-blog-feed-title-text">
                <h3><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></h3>
                <?php the_excerpt(); ?>
            </div>
            <div class="ft-btn-2">
                <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>">
                    <i class="icon-first flaticon-right-arrow"></i>
                    <span><?php esc_html_e('Read More', 'fastrans'); ?></span>
                </a>
            </div>
        </div>
    </div>
        
</div>