<?php
/**
 * Banner Template
 *
 * @package    WordPress
 * @subpackage Themexriver
 * @author     Themexriver
 * @version    1.0
 */

if ( $data->get( 'enable_banner' ) AND $data->get( 'banner_type' ) == 'e' AND ! empty( $data->get( 'banner_elementor' ) ) ) {
	echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $data->get( 'banner_elementor' ) );

	return false;
}

?>
<?php if ( $data->get( 'enable_banner' ) ) : ?>

	<!-- Start of Breadcrumb section
	============================================= -->
	<section id="ft-breadcrumb" class="ft-breadcrumb-section position-relative" data-background="'<?php echo esc_url( $data->get( 'banner' ) ); ?>'" style="background-image:url('<?php echo esc_url( $data->get( 'banner' ) ); ?>')">
		<span class="background_overlay"></span>
		<span class="design-shape position-absolute"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/shape/tmd-sh.png" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>"></span>
		<div class="container">
			<div class="ft-breadcrumb-content headline text-center position-relative">
				<h2><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h2>
				<div class="ft-breadcrumb-list ul-li">
					<ul>
						<?php echo fastrans_the_breadcrumb(); ?>
					</ul>
				</div>
			</div>
		</div>
	</section>	
	<!-- End of Breadcrumb section
	============================================= -->
        
<?php endif; ?>