<?php

return array(
	'title'      => esc_html__( 'Single Post Settings', 'fastrans' ),
	'id'         => 'single_post_setting',
	'desc'       => '',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'      => 'single_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Single Post Source Type', 'fastrans' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'fastrans' ),
				'e' => esc_html__( 'Elementor', 'fastrans' ),
			),
			'default' => 'd',
		),
		
		array(
			'id'       => 'single_default_st',
			'type'     => 'section',
			'title'    => esc_html__( 'Post Default', 'fastrans' ),
			'indent'   => true,
			'required' => [ 'single_source_type', '=', 'd' ],
		),
		array(
			'id'      => 'single_post_date',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Date', 'fastrans' ),
			'desc'    => esc_html__( 'Enable to show post publish date on posts detail page', 'fastrans' ),
			'default' => true,
		),
		array(
			'id'      => 'single_post_author',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Author', 'fastrans' ),
			'desc'    => esc_html__( 'Enable to show author on posts detail page', 'fastrans' ),
			'default' => true,
		),
		array(
			'id'      => 'single_post_comments',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Comments', 'fastrans' ),
			'desc'    => esc_html__( 'Enable to show number of comments on posts single page', 'fastrans' ),
			'default' => true,
		),
		array(
			'id'      => 'facebook_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Facebook Post Share', 'fastrans' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Facebook', 'fastrans' ),
			'default' => false,
		),
		array(
			'id'      => 'twitter_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Twitter Post Share', 'fastrans' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Twitter', 'fastrans' ),
			'default' => false,
		),
		array(
			'id'      => 'linkedin_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Linkedin Post Share', 'fastrans' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Linkedin', 'fastrans' ),
			'default' => false,
		),
		array(
			'id'      => 'pinterest_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Pinterest Post Share', 'fastrans' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Pinterest', 'fastrans' ),
			'default' => false,
		),
		array(
			'id'      => 'reddit_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Reddit Post Share', 'fastrans' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Reddit', 'fastrans' ),
			'default' => false,
		),
		array(
			'id'      => 'tumblr_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Tumblr Post Share', 'fastrans' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Tumblr', 'fastrans' ),
			'default' => false,
		),
		array(
			'id'      => 'digg_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Digg Post Share', 'fastrans' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Digg', 'fastrans' ),
			'default' => false,
		),
		array(
			'id'      => 'single_post_author_box',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Author Box', 'fastrans' ),
			'desc'    => esc_html__( 'Enable to show author box on post detail page.', 'fastrans' ),
			'default' => false,
		),
		array(
			'id'      => 'single_post_author_links',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Author Social Media', 'fastrans' ),
			'desc'    => esc_html__( 'Enable to show author Social Media on posts detail page', 'fastrans' ),
			'default' => false,
		),
		array(
			'id'    => 'single_post_author_social_share',
			'type'  => 'social_media',
			'title' => esc_html__( 'Author Social Profiles', 'fastrans' ),
			'desc'    => esc_html__( 'show author Social Media on posts detail page', 'fastrans' ),
		),
		array(
			'id'       => 'single_section_default_ed',
			'type'     => 'section',
			'indent'   => false,
			'required' => [ 'single_source_type', '=', 'd' ],
		),
	),
);





