<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Video_Section extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_video_section';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Video Section', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'video_section',
				[
					'label' => esc_html__( 'Video Section', 'fastrans' ),
				]
		);
		$this->add_control(
			'video_image',
			[
			  'label' => __( 'Video Image', 'fastrans' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
            'video_link',
			[
				'label' => __( 'Video Url', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>
	
    <!-- Start of Video section
	============================================= -->
	<section id="ft-video" class="ft-video-section">
		<div class="container">
			<div class="ft-video-content position-relative">
				<div class="ft-video-img-play-btn">
					<?php if($settings['video_image']['id']){ ?>
                    <div class="ft-video-img">
						<img src="<?php echo esc_url(wp_get_attachment_url($settings['video_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>">
					</div>
					<?php } ?>
                    <?php if($settings['video_link']['url']){ ?>
                    <div class="ft-video-play">
						<a class="d-flex justify-content-center align-items-center position-relative video_box" href="<?php echo esc_url($settings['video_link']['url']); ?>">
							<i class="fas fa-play"></i>
							<span class="video_btn_border border_wrap-1"></span>
							<span class="video_btn_border border_wrap-2"></span>
						</a>
					</div>
                    <?php } ?>
				</div>
			</div>
		</div>		
	</section>	
	<!-- End of Video section
	============================================= -->
    
    <?php 
	
	}

}