<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Transport_Team extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_transport_team';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Transport Team', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'our_teams_v5',
			[
				'label' => esc_html__( 'Our teams V5', 'fastrans' ),
			]
		);
        $this->add_control(
            'sub_heading', [
                'label'       => esc_html__( 'Sub heading', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'heading', [
                'label'       => esc_html__( 'heading', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'team_img',
            [
                'label' => esc_html__( 'Team Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'member_name', [
                'label'       => esc_html__( 'Mamber Name', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        
        $repeater->add_control(
            'designation', [
                'label'       => esc_html__( 'Designation', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'team_excerpt', [
                'label'       => esc_html__( 'Team Short Description', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        
        $repeater->add_control(
            'phone_no', [
                'label'       => esc_html__( 'Phone NO', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'btn_label', [
                'label'       => esc_html__( 'Button Label', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'btn_link', [
                'label'       => esc_html__( 'Button Link', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::URL,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'fb_link', [
                'label'       => esc_html__( 'Facebook', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::URL,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'tw_link', [
                'label'       => esc_html__( 'Twitter', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::URL,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'linkd_link', [
                'label'       => esc_html__( 'Linkedin', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::URL,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'inst_link', [
                'label'       => esc_html__( 'Instagram', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::URL,
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'team_boxes',
            [
                'label'       => __( 'Add Item', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ member_name }}}',
            ]
        );
		$this->end_controls_section();
		$this->start_controls_section(
			'team_0style',
			[
				'label' => esc_html__( 'Team Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'tm_name_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Name Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'name_typography',
                'label'          => esc_html__( 'Typography', 'prysm' ),
                'selector'       => '{{WRAPPER}} .team-block-two .inner-box .lower-content .content h5',
                'fields_options' => [
                    'font_family' => [
                        'default' => 'Poppins',
                    ],
					'font_weight' => [
                        'default' => '700',
                    ],
                    'font_size'   => [
                        'default' => [
                            'size' => '22',
                        ],
                    ],
                ],
            ]
        );
		$this->add_control(
			'phorn_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Phone Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'deg_typography',
                'label'          => esc_html__( 'Typography', 'prysm' ),
                'selector'       => '{{WRAPPER}} .team-block-two .inner-box .lower-content .phone',
                'fields_options' => [
                    'font_family' => [
                        'default' => 'Inter',
                    ],
                ],
            ]
        );
		$this->add_control(
			'des_name_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Designation Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'des_typography',
                'label'          => esc_html__( 'Typography', 'prysm' ),
                'selector'       => '{{WRAPPER}} .team-block-two .inner-box .lower-content .designation',
                'fields_options' => [
                    'font_family' => [
                        'default' => 'Inter',
                    ],
                ],
            ]
        );
		$this->end_controls_section();
	}
	
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$sub_heading = $settings['sub_heading'];
		$heading     = $settings['heading'];
		$team_boxes = $settings['team_boxes'];
        
        ?>
<!-- Team Section Two -->
<section class="team-section-two">
			<div class="auto-container">
				<div class="sec-title-two style-two">
					<div class="title"><?php echo esc_html($sub_heading);?></div>
					<h2><?php echo esc_html($heading);?></h2>
				</div>
				<div class="team-carousel-two owl-carousel owl-theme">
                    <?php foreach($team_boxes as $index => $box): ?>
					<!-- Team Block Two -->
					<div class="team-block-two">
						<div class="inner-box">
							<div class="image">
								<img src="<?php echo esc_url($box['team_img']['url']);?>" alt="" />
								<!-- Overlay Box -->
								<div class="overlay-box">
									<div class="shape-layer"></div>
									<div class="overlay-inner">
										<div class="content">
											<div class="author-image">
												<img src="<?php echo esc_url($box['team_img']['url']);?>" alt="" />
											</div>
											<div class="text"><?php echo esc_html($box['team_excerpt']);?></div>
											<!-- Social Box -->
											<ul class="social-box">
                                                <?php if($box['fb_link']['url']):?>
												<li><a href="<?php echo esc_url($box['fb_link']['url']);?>" class="fab fa-facebook-f"></a></li>
                                                <?php endif;?>
                                                
                                                <?php if($box['tw_link']['url']):?>
												<li><a href="<?php echo esc_url($box['tw_link']['url']);?>" class="fab fa-twitter"></a></li>
                                                <?php endif;?>

                                                <?php if($box['linkd_link']['url']):?>
												<li><a href="<?php echo esc_url($box['linkd_link']['url']);?>" class="fab fa-linkedin"></a></li>
                                                <?php endif;?>

                                                <?php if($box['inst_link']['url']):?>
												<li><a href="<?php echo esc_url($box['inst_link']['url']);?>" class="fab fa-instagram"></a></li>
                                                <?php endif;?>
											</ul>
											<!-- End Social Box -->
										</div>
									</div>
								</div>
							</div>
							<div class="lower-content">
								<div class="content">
									<h5><a href="#"><?php echo esc_html($box['member_name']);?></a></h5>
									<div class="designation"><?php echo esc_html($box['designation']);?></div>
									<div class="phone-number">
										<a class="phone" href="tel:<?php echo $box['phone_no']?>"><?php echo esc_attr($box['phone_no']);?></a>
									</div>
								</div>
								<a href="<?php echo esc_url($box['btn_link']['url']);?>" class="more"><?php echo esc_html($box['btn_label']);?> <span class="fa fa-angle-right"></span></a>
							</div>
						</div>
					</div>					
					<?php endforeach;?>
				</div>
			</div>
		</section>
		<!-- End Team Section Two -->
        <?php 
	}
    
}