<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Transport_Slider extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrance_transport_slider';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Transport Slider Section', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'transport_slider',
			[
				'label' => esc_html__( 'Slider Option', 'fastrans' ),
			]
		);
		$repeater = new Repeater();
		
		$repeater->add_control(
			'slider_bg_img', [
				'label'       => esc_html__( 'Background Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'description', [
				'label'       => esc_html__( 'Description', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'btn_label', [
				'label'       => esc_html__( 'Button Label', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'btn_link',
			[
				'label' => __( 'Link', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'fastrans' ),
			]
		);
		$this->add_control(
			'transport_slides',
			[
				'label'       => __( 'Add Item', 'fastrans-extension' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display(); 
        $transport_slides = $settings['transport_slides'];
    ?>
        <!-- Main Slider Two -->
        <section class="main-slider-two">
                    
            <!-- Shop Single -->
            <div class="product-details">
                
                <!-- Basic Details -->
                <div class="basic-details">
                    <div class="image-column">
                        <div class="carousel-outer">
                            <ul class="image-carousel owl-carousel owl-theme">
                                <?php foreach($transport_slides as $item):?>
                                <li>
                                    <!--Slide-->
                                    <div class="slide-two-content">
                                        <div class="inner-box">
                                            <div class="pattern-layer"></div>
                                            <div class="image-box">
                                                <div class="image">
                                                    <img class="wow fadeIn" data-wow-delay="0ms" data-wow-duration="2500ms" src="<?php echo esc_url($item['slider_bg_img']['url']);?>" alt="" />
                                                    <div class="overlay-box">
                                                        <div class="overlay-inner">
                                                            <div class="content">
                                                                <div class="content-inner">
                                                                    <h2><a href="<?php echo esc_url($item['btn_link']['url']);?>"><?php echo esc_html($item['title']);?></a></h2>
                                                                    <div class="text"><?php echo __($item['description']);?></div>
                                                                    <a href="<?php echo esc_url($item['btn_link']['url']);?>" class="read-more theme-btn"><?php echo esc_html($item['btn_label']);?></a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </li>
                                <?php endforeach;?>    
                            </ul>
                            
                            <ul class="thumbs-carousel owl-carousel owl-theme">
                                <?php foreach($transport_slides as $item):?>
                                    <li><?php echo esc_html($item['title']);?></li>
                                <?php endforeach;?>   
                            </ul>
                            
                        </div>
                    </div>
                        
                </div>
                <!--Basic Details-->
                
            </div>
            
        </section>
        <!-- End Main Slider Two -->
	<?php	
	}

}
