<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Transport_Project_Carousel extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_transport_project_car';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Projects V6', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'our_projects_v5',
			[
				'label' => esc_html__( 'Our Projects V5', 'fastrans' ),
			]
		);
        $this->add_control(
            'sub_heading', [
                'label'       => esc_html__( 'Sub heading', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'heading', [
                'label'       => esc_html__( 'heading', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'portfolio_id', [
                'label'       => esc_html__( 'Select portfolio', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'options'     => $this->select_param_posts(),
            ]
        );

        $repeater->add_control(
            'hr',
            [
                'type'  => \Elementor\Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );
        

        $repeater->add_control(
            'project_img',
            [
                'label' => esc_html__( 'portfolio Icon', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'project_excerpt', [
                'label'       => esc_html__( 'Project Short Description', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'project_btn', [
                'label'       => esc_html__( 'Project Button Label', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'portfolio_boxes',
            [
                'label'       => __( 'Add Item', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
            ]
        );
		$this->end_controls_section();
		$this->start_controls_section(
			'projects_style',
			[
				'label' => esc_html__( 'Project Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'project_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Project Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'pt_typography',
                'label'          => esc_html__( 'Typography', 'prysm' ),
                'selector'       => '{{WRAPPER}} .portfolio-block .inner-box .content-box h4',
                'fields_options' => [
                    'font_family' => [
                        'default' => 'Poppins',
                    ],
					'font_weight' => [
                        'default' => '700',
                    ],
                    'font_size'   => [
                        'default' => [
                            'size' => '24',
                        ],
                    ],
                ],
            ]
        );
		$this->add_control(
			'project_number_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Project Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'no_typography',
                'label'          => esc_html__( 'Typography', 'prysm' ),
                'selector'       => '{{WRAPPER}} .portfolio-block .inner-box .image .number',
                'fields_options' => [
                    'font_family' => [
                        'default' => 'Inter',
                    ],
					'font_weight' => [
                        'default' => '700',
                    ],
                    'font_size'   => [
                        'default' => [
                            'size' => '150',
                        ],
                    ],
                ],
            ]
        );
		
		$this->end_controls_section();
	}
	
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$sub_heading = $settings['sub_heading'];
		$heading     = $settings['heading'];
		$portfolio_boxes = $settings['portfolio_boxes'];
        
        ?>

        

        <!-- Portfolio Section -->
		<section class="portfolio-section">
			<div class="auto-container">
				<div class="sec-title-two style-two">
					<div class="title"><?php echo esc_html($sub_heading);?></div>
					<h2><?php echo esc_html($heading);?></h2>
				</div>
				<div class="project-carousel-two owl-carousel owl-theme">
				
                <?php $shape = 0; foreach($portfolio_boxes as $index => $box): $shape++;?>
                <?php  if( $box['portfolio_id'] ) : ?>
					<!-- Portfolio Block -->
					<div class="portfolio-block">
						<div class="inner-box">
							<div class="image">
								<img src="<?php echo esc_url($box['project_img']['url']);?>" alt="" />
								<div class="number"><?php echo esc_attr($shape);?></div>
							</div>
							<div class="content-box">
								<h4><a href="<?php echo esc_url(get_post_meta( $box['portfolio_id'], 'project_url', true ));?>"><?php echo get_the_title($box['portfolio_id']);?></a></h4>
								<div class="text"><?php echo esc_html($box['project_excerpt']);?></div>
								<a href="<?php echo esc_url(get_post_meta( $box['portfolio_id'], 'project_url', true ));?>" class="read-more theme-btn"><?php echo esc_html($box['project_btn']);?></a>
							</div>
						</div>
					</div>
					<?php endif; endforeach;?>
				</div>
			</div>
		</section>
		<!-- End Portfolio Section -->
        <?php 
	}
    protected function select_param_posts() {
        $args = wp_parse_args( [
            'post_type'   => 'project',
            'numberposts' => -1,
            'orderby'     => 'title',
            'order'       => 'ASC',
        ] );
    
        $query_query = get_posts( $args );
    
        $posts = [];
        if ( $query_query ) {
            foreach ( $query_query as $query ) {
                $posts[$query->ID] = $query->post_title;
            }
        }
    
        return $posts;
    }
}