<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Transport_Fanfact extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrance_transport_fanfact';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Fastrans Transport Fanfact', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'fanfact_content',
			[
				'label' => esc_html__( 'Fanfact Option', 'fastrans' ),
			]
		);        
		
		$this->add_control(
			'fanfact_bg', [
				'label'       => esc_html__( 'Background Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
        $repeater = new Repeater();
		$repeater->add_control(
			'icon', [
				'label'       => esc_html__( 'Icon', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'number', [
				'label'       => esc_html__( 'Description', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'symbole', [
				'label'       => esc_html__( 'Symbole', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);		
		$this->add_control(
			'fanfacts',
			[
				'label'       => __( 'Add Item', 'fastrans-extension' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);		
		
		$this->end_controls_section();
		$this->start_controls_section(
			'services_style',
			[
				'label' => esc_html__( 'service Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'fnf_no_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Number Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'title-h_typography',
                'label'          => esc_html__( 'Typography', 'prysm' ),
                'selector'       => '{{WRAPPER}} .fact-counter.style-two .column .inner .count-outer',
                'fields_options' => [
                    'font_family' => [
                        'default' => 'Inter',
                    ],
					'font_weight' => [
                        'default' => '700',
                    ],
                    'font_size'   => [
                        'default' => [
                            'size' => '46',
                        ],
                    ],
                ],
            ]
        );
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display(); 
        $fanfact_bg = $settings['fanfact_bg']['url'];
        $fanfacts = $settings['fanfacts'];
    ?>
    <!-- Counter Section -->
		<section class="counter-section" style="background-image:url(<?php echo esc_url($fanfact_bg);?>)">
			<div class="auto-container">
				<!-- Fact Counter -->
				<div class="fact-counter style-two">
					<div class="row clearfix">
                        <?php foreach($fanfacts as $item):?>
						<!-- Column -->
						<div class="column col-lg-3 col-md-6 col-ms-12">
							<div class="inner">
								<div class="content">
									<div class="icon <?php echo esc_attr($item['icon']);?>"></div>
									<div class="count-outer count-box">
										<span class="count-text counter"><?php echo esc_attr($item['number']);?></span><?php echo esc_attr($item['symbole']);?>
									</div>
									<div class="counter-title"><?php echo esc_html($item['title']);?></div>
								</div>
							</div>
						</div>
						<?php endforeach;?>
					</div>
				</div>
				
			</div>
		</section>
		<!-- End Counter Section -->
	<?php	
	}

}
