<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Service_Details extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_service_details';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Service Details', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'service_details',
				[
					'label' => esc_html__( 'Service Details', 'fastrans' ),
				]
		);
		$this->add_control(
			'sidebar_slug',
			[
				'label'   => esc_html__( 'Choose Sidebar', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'Choose Sidebar',
				'options'  => fastrans_get_sidebars(),
			]
		);
		$this->add_control(
			'service_image',
			[
			  'label' => __( 'Feature Image V1', 'fastrans' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'service_image_v2',
			[
			  'label' => __( 'Feature Image V2', 'fastrans' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'service_image_v3',
			[
			  'label' => __( 'Feature Image V3', 'fastrans' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'fastrans' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Content', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Content/Description', 'fastrans' ),
			]
		);
		$this->add_control(
            'show_features_area',
			[
				'label' => __( 'Enable/Disable Counter Box', 'fastrans' ),
				'type'     => Controls_Manager::SWITCHER,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enable/Disable Counter Box', 'fastrans' ),
			]
		);
		$this->add_control(
            'features', 
			  	[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
				[
					['block_title' => esc_html__('WE COVERED', 'fastrans')],
					['block_title' => esc_html__('WE HANDLED', 'fastrans')]
				],
			'fields' => 
				[
					[
						'name' => 'icons',
						'label' => esc_html__('Enter The icons', 'fastrans'),
						'label_block' => true,
						'type' => Controls_Manager::SELECT2,
						'options'  => get_fontawesome_icons(),
					],
					[
						'name' => 'counter_value',
						'label' => esc_html__('Counter Value', 'fastrans'),
						'type' => Controls_Manager::TEXT,
						'label_block' => true,
					],
					[
						'name' => 'alphabet_letter',
						'label' => esc_html__('Alphabet Letter', 'fastrans'),
						'type' => Controls_Manager::TEXT,
						'label_block' => true,
					],
					[
						'name' => 'block_title',
						'label' => esc_html__('Title', 'fastrans'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('', 'fastrans')
					],
					[
						'name' => 'block_text',
						'label' => esc_html__('Description', 'fastrans'),
						'label_block' => true,
						'type' => Controls_Manager::TEXTAREA,
						'default' => esc_html__('', 'fastrans')
					],
				],
				'title_field' => '{{block_title}}',
            ]
        );
		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title Here', 'fastrans' ),
			]
		);
		$this->add_control(
			'text2',
			[
				'label'       => __( 'Description', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'fastrans' ),
			]
		);
		$this->add_control(
			'video_image',
			[
			  'label' => __( 'Video Image', 'fastrans' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
            'video_link',
			[
				'label' => __( 'Video Url', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>
	
    <!-- Start of Service details section
	============================================= -->
	<section id="ft-service-details" class="ft-service-details-section page-padding">
		<div class="container">
			<div class="ft-service-details-content">
				<div class="row">
					<?php if ( is_active_sidebar( $settings['sidebar_slug'] ) ) : ?>
                    <div class="col-lg-4">
						<div class="ft-service-sidebar">
                        	<?php dynamic_sidebar( $settings['sidebar_slug'] ); ?>
						</div>
					</div>
					<?php endif; ?>
                    <div class="<?php if ( is_active_sidebar( $settings['sidebar_slug'] ) ) echo 'col-lg-8'; else echo 'col-lg-12'; ?>">
						<div class="ft-service-details-content-wrapper headline pera-content">
							<div class="ft-service-details-img-wrapper">
								<div class="row">
									<?php if($settings['service_image']['id']){ ?>
                                    <div class="col-md-6">
										<div class="ft-service-details-img">
											<img src="<?php echo esc_url(wp_get_attachment_url($settings['service_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>">
										</div>
									</div>
                                    <?php } ?>
                                    <?php if($settings['service_image_v2']['id'] || $settings['service_image_v3']['id']){ ?>
									<div class="col-md-6">
										<?php if($settings['service_image_v2']['id']){ ?>
                                        <div class="ft-service-details-img">
											<img src="<?php echo esc_url(wp_get_attachment_url($settings['service_image_v2']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>">
										</div>
                                        <?php } ?>
                                        <?php if($settings['service_image_v3']['id']){ ?>
										<div class="ft-service-details-img">
											<img src="<?php echo esc_url(wp_get_attachment_url($settings['service_image_v3']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>">
										</div>
                                        <?php } ?>
									</div>
                                    <?php } ?>
								</div>
							</div>
							<div class="ft-service-details-text-wrapper">
								<?php if($settings['title']){ ?><h3><?php echo wp_kses($settings['title'], true); ?></h3> <?php } ?>
								
								<?php echo wp_kses($settings['text'], true); ?>
								
								<?php if($settings['show_features_area']){ ?>
                                <div class="ft-service-details-counter-wrapper">
									<div class="row">
										<?php foreach($settings['features'] as $key => $item): ?>
                                        <div class="col-md-6">
											<div class="ft-service-details-counter-item d-flex align-items-center headline pera-content">
												<div class="ft-service-details-count-icon">
													<i class="<?php echo esc_attr(str_replace( "icon ",  "", $item['icons']));?>"></i>
												</div>
												<div class="ft-service-details-count-text">
													<h4 class="title text-uppercase"><?php echo wp_kses($item['block_title'], true);?></h4>
													<h4 class="count-number"><span class="count"><?php echo esc_attr($item['counter_value']);?></span><?php echo esc_attr($item['alphabet_letter']);?></h4>
													<p><?php echo wp_kses($item['block_text'], true);?></p>
												</div>
											</div>
										</div>
                                        <?php endforeach; ?>
									</div>
								</div>
								<?php } ?>
								<?php if($settings['sub_heading']){ ?>
                                <h3><?php echo wp_kses($settings['sub_heading'], true); ?></h3>
                                <?php } ?>
                                <?php if($settings['text2']){ ?>
                                <p><?php echo wp_kses($settings['text2'], true); ?> </p>
								<?php } ?>
								<?php if($settings['video_image']['id'] || $settings['video_link']['url']){ ?>
                                <div class="ft-video-content position-relative">
									<div class="ft-video-img-play-btn">
										<?php if($settings['video_image']['id']){ ?>
                                        <div class="ft-video-img">
											<img src="<?php echo esc_url(wp_get_attachment_url($settings['video_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>">
										</div>
                                        <?php } ?>
                    					<?php if($settings['video_link']['url']){ ?>
										<div class="ft-video-play">
											<a class="d-flex justify-content-center align-items-center position-relative video_box" href="<?php echo esc_url($settings['video_link']['url']); ?>">
												<i class="fas fa-play"></i>
												<span class="video_btn_border border_wrap-1"></span>
												<span class="video_btn_border border_wrap-2"></span>
											</a>
										</div>
                                        <?php } ?>
									</div>
								</div>
                                <?php } ?>    	
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>	
	<!-- End of Service details section
	============================================= -->
    
    <?php 
	
	}

}