<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Pricing_Plan extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_pricing_plan';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Pricing Plan', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'pricing_plan',
			[
				'label' => esc_html__( 'Pricing Plan', 'fastrans' ),
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'fastrans' ),
			]
		);
		$this->add_control(
            'pricing_table', 
			  	[
				'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
				'default' => 
					[
						['plan_title' => esc_html__('Basic Plan', 'fastrans')],
						['plan_title' => esc_html__('Popular Plan', 'fastrans')],
						['plan_title' => esc_html__('Premium Plan', 'fastrans')]
					],
			'fields' => 
				[
					[
						'name' => 'show_pattern_image',
						'label' => __( 'Enable/Disable Pattern Image', 'fastrans' ),
						'type'     => Controls_Manager::SWITCHER,
						'dynamic'     => [
							'active' => true,
						],
						'placeholder' => __( 'Enable/Disable Pattern Image', 'fastrans' ),
					],
					[
						'name' => 'plan_title',
						'label' => esc_html__('Plan Title', 'fastrans'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('', 'fastrans')
					],
					[
						'name' => 'price',
						'label' => esc_html__('Price', 'fastrans'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('', 'fastrans')
					],
					[
						'name' => 'duration',
						'label' => esc_html__('Duration', 'fastrans'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('', 'fastrans')
					],
					[
						'name' => 'features_list',
						'label' => esc_html__('Feature List', 'fastrans'),
						'type' => Controls_Manager::TEXTAREA,
						'default' => esc_html__('', 'fastrans')
					],
					[
						'name' => 'btn_title',
						'label' => esc_html__('Button Title', 'fastrans'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('Try It Now', 'fastrans')
					],
					[
						'name' => 'btn_link',
						'label' => __( 'External Url', 'fastrans' ),
						'type' => Controls_Manager::URL,
						'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
						'show_external' => true,
						'default' => ['url' => '','is_external' => true,'nofollow' => true,],
					],
				],
				'title_field' => '{{plan_title}}',
            ]
        );
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>
	
    <!-- Start of Pricing plan section
	============================================= -->
	<section id="ft-pricing-plan" class="ft-pricing-plan-section page-padding">
		<div class="container">
			<?php if($settings['subtitle'] || $settings['title']){ ?>
            <div class="ft-section-title headline pera-content text-center">
				<?php if($settings['subtitle']){ ?><span class="sub-title"><?php echo wp_kses($settings['subtitle'], true); ?></span><?php } ?>
				<?php if($settings['title']){ ?><h2><?php echo wp_kses($settings['title'], true); ?></h2><?php } ?>
            </div>
            <?php } ?>
			<div class="ft-pricing-plan-content">
				<div class="row justify-content-center">
					<?php foreach($settings['pricing_table'] as $key => $item):?>
                    <div class="col-lg-4 col-md-6">
						<div class="ft-pricing-plan-items headline ul-li-block text-center position-relative">
							<?php if($item['show_pattern_image']){ ?>
                            <span class="pricing-shape1 position-absolute"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/shape/p-sh1.png" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>"></span>
							<span class="pricing-shape2 position-absolute"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/shape/p-sh2.png" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>"></span>
							<?php } ?>
                            <div class="ft-pricing-plan-head">
								<h3><?php echo wp_kses($item['plan_title'], true); ?></h3>
							</div>
							<div class="ft-pricing-plan-value">
								<h4><?php echo wp_kses($item['price'], true); ?></h4>
								<span><?php echo wp_kses($item['duration'], true); ?></span>
							</div>
							<?php $features_list = $item['features_list'];
								if(!empty($features_list)){
								$features_list = explode("\n", ($features_list)); 
							?>
                            <div class="ft-pricing-plan-list clearfix">
								<ul>
								<?php foreach($features_list as $features): ?>
                                   <li><?php echo wp_kses($features, true); ?></li>
                                <?php endforeach; ?>
								</ul>
							</div>
                            <?php } ?>
                            
                            <?php if($item['btn_link']['url'] || $item['btn_title']){ ?>
							<div class="ft-btn-2">
								<a href="<?php echo esc_url($item['btn_link']['url']); ?>">
									<i class="icon-first flaticon-right-arrow"></i>
									<span><?php echo wp_kses($item['btn_title'], true); ?></span>
								</a>
							</div>
                            <?php } ?>
						</div>
					</div>
                    <?php endforeach;?>
				</div>
			</div>
		</div>
	</section>	
	<!-- End of Pricing plan section
	============================================= -->
		
    <?php 
	
	}

}