<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Projects_V5 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_our_projects_v5';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Projects V5', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'our_projects_v5',
			[
				'label' => esc_html__( 'Our Projects V5', 'fastrans' ),
			]
		);
		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'portfolio_id', [
                'label'       => esc_html__( 'Select portfolio', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'options'     => $this->select_param_posts(),
            ]
        );

        $repeater->add_control(
            'hr',
            [
                'type'  => \Elementor\Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );
        

        $repeater->add_control(
            'project_img',
            [
                'label' => esc_html__( 'portfolio Icon', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'project_cat', [
                'label'       => esc_html__( 'Project Category', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'portfolio_boxes',
            [
                'label'       => __( 'Add Item', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
            ]
        );
        $this->add_control(
            'scoll_btmlink', [
                'label'       => esc_html__( 'Scoll Bottm Link', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
		$this->end_controls_section();
		$this->start_controls_section(
			'projects_style',
			[
				'label' => esc_html__( 'Project Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-v5-portfolio-text h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-v5-portfolio-text h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'text_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Text Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'text_clr',
			[
				'label'     => esc_html__( 'Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-v5-portfolio-text span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'text_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-v5-portfolio-text span',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'button_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Button Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'btn_clr',
			[
				'label'     => esc_html__( 'Button Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-btn-3 a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'btn_bg_clr',
			[
				'label'     => esc_html__( 'Button BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-btn-3 a' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'btn_hover_clr',
			[
				'label'     => esc_html__( 'Button Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-btn-3 a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'btn_hover_bg_clr',
			[
				'label'     => esc_html__( 'Button Hover BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-btn-3 a:hover' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'btn_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-btn-3 a',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
	}
	
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$portfolio_boxes = $settings['portfolio_boxes'];
        
        ?>
		
        <!-- Start of Project section
        ============================================= -->
        <section id="ft-portfolio-5" class="ft-portfolio-section-5 position-relative">
            <div class="ft-portfolio-content-5">
                <div class="ft-portfolio-slider-5">
                <?php $shape = 0; foreach($portfolio_boxes as $index => $box): $shape++;?>
                <?php  if( $box['portfolio_id'] ) : ?>
                    <div class="ft-project-v5-slider-item">
                        <div class="ft-project-v5-slider-innerbox position-relative">
                            <div class="ft-project-v5-img">
                                <img src="<?php echo esc_url($box['project_img']['url']);?>" alt="">
                            </div>
                            <div class="ft-v5-portfolio-text headline headline pera-content">
                                <span><?php echo esc_html($box['project_cat']);?></span>
                                <h3><a href="<?php echo esc_url(get_post_meta( $box['portfolio_id'], 'project_url', true ));?> "><?php echo get_the_title($box['portfolio_id']);?></a></h3>
                            </div>
                        </div>
                    </div>
                    <?php endif; endforeach;?>
                </div>
            </div>
        </section>
        
		<div class="arrwo-animate animated">
		<a href="<?php echo esc_url($settings['scoll_btmlink']);?>">
		<div class="circle circle-top"></div>  
		<div class="circle circle-main"></div>
		<div class="circle circle-bottom"></div>  
		
		<svg class="svg" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 612 612" style="enable-background:new 0 0 612 612;" xml:space="preserve" >
		<defs>
			<clipPath id="cut-off-arrow">
			<circle cx="306" cy="306" r="287"/>
			</clipPath>
			
			<filter id="goo">
			<feGaussianBlur in="SourceGraphic" stdDeviation="10" result="blur" />
			<feColorMatrix in="blur" mode="matrix" values="1 0 0 0 0  0 1 0 0 0  0 0 1 0 0  0 0 0 18 -7" result="goo" />
			<feBlend in="SourceGraphic" in2="goo" />
			</filter>
		
		</defs>
			<path  class="st-arrow" d="M317.5,487.6c0.3-0.3,0.4-0.7,0.7-1.1l112.6-112.6c6.3-6.3,6.3-16.5,0-22.7c-6.3-6.3-16.5-6.3-22.7,0
							l-86,86V136.1c0-8.9-7.3-16.2-16.2-16.2c-8.9,0-16.2,7.3-16.2,16.2v301.1l-86-86c-6.3-6.3-16.5-6.3-22.7,0
							c-6.3,6.3-6.3,16.5,0,22.7l112.7,112.7c0.3,0.3,0.4,0.7,0.7,1c0.5,0.5,1.2,0.5,1.7,0.9c1.7,1.4,3.6,2.3,5.6,2.9
							c0.8,0.2,1.5,0.4,2.3,0.4C308.8,492.6,313.8,491.3,317.5,487.6z"/>
		</svg>
		</a>
		</div>
    	<!-- End of Project section
        ============================================= -->
        <?php 
	}
    protected function select_param_posts() {
        $args = wp_parse_args( [
            'post_type'   => 'project',
            'numberposts' => -1,
            'orderby'     => 'title',
            'order'       => 'ASC',
        ] );
    
        $query_query = get_posts( $args );
    
        $posts = [];
        if ( $query_query ) {
            foreach ( $query_query as $query ) {
                $posts[$query->ID] = $query->post_title;
            }
        }
    
        return $posts;
    }
}