<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Funfacts extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_funfacts';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Funfacts', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'funfacts',
				[
					'label' => esc_html__( 'Funfacts', 'fastrans' ),
				]
		);
		$this->add_control(
			'style_two',
			[
				'label'   => esc_html__( 'Choose Layout Style', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'one',
				'options' => array(
					'one' => esc_html__( 'Style One', 'fastrans' ),
					'two'  => esc_html__( 'Style Two', 'fastrans' ),
				),
			]
		);
		$this->add_control(
			'bg_image',
				[
				  'label' => __( 'BG pattern Image', 'fastrans' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'map_pattern_image',
				[
				  'label' => __( 'Map pattern Image', 'fastrans' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'fastrans' ),
			]
		);
		$this->add_control(
        	'funfact', 
				[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
					[
						['block_title' => esc_html__('Completed Delivery', 'fastrans')],
						['block_title' => esc_html__('Satisfied Clients', 'fastrans')],
						['block_title' => esc_html__('Awards Winner', 'fastrans')],
						['block_title' => esc_html__('Team Members', 'fastrans')]
					],
				'fields' => 
					[
						[
							'name' => 'icons',
							'label' => esc_html__('Enter The icons', 'fastrans'),
							'label_block' => true,
							'type' => Controls_Manager::SELECT2,
							'options'  => get_fontawesome_icons(),
						],
						[
							'name' => 'counter_value',
							'label' => esc_html__('Counter Value', 'fastrans'),
							'type' => Controls_Manager::TEXT,
							'label_block' => true,
						],
						[
							'name' => 'alphabet_letter',
							'label' => esc_html__('Alphabet Letter', 'fastrans'),
							'type' => Controls_Manager::TEXT,
							'label_block' => true,
						],
						[
							'name' => 'block_title',
							'label' => esc_html__('Block Title', 'fastrans'),
							'label_block' => true,
							'type' => Controls_Manager::TEXT,
							'default' => esc_html__('Enter Title Here', 'fastrans')
						],
					],
				'title_field' => '{{block_title}}',
            ]
        );
		$this->add_control(
			'bottom_text',
			[
				'label'       => __( 'Section Bottom Description', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Section Bottom Description', 'fastrans' ),
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'funfact_s_heading_style',
			[
				'label' => esc_html__( 'Funfact Section Heading Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'sub_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Sub Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sub_title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-funfact-section-2 .ft-section-title-3 span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sub_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-funfact-section-2 .ft-section-title-3 span',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'main_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-funfact-section-2 .ft-section-title-3 h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-funfact-section-2 .ft-section-title-3 h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'funfact_style',
			[
				'label' => esc_html__( 'Funfact Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'icon_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Icon Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'fnf_icon_color',
			[
				'label'     => esc_html__( 'Icon Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-funfact-inner-items .ft-funfact-inner-icon i' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'fnf_icon_bg_color',
			[
				'label'     => esc_html__( 'Icon BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-funfact-inner-items .ft-funfact-inner-icon' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'fnf_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'fnf_title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-funfact-inner-items .ft-funfact-inner-text p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'fnf_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-funfact-inner-items .ft-funfact-inner-text p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'fnf_number_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'FNF Number Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'fnf_number_clr',
			[
				'label'     => esc_html__( 'Number Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-funfact-inner-items .ft-funfact-inner-text h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'fnf_number_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-funfact-inner-items .ft-funfact-inner-text h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>
	
    <?php if( $settings[ 'style_two' ] == 'two' ):?>
	<!-- Start of Fun fact section
	============================================= -->
	<section id="ft-funfact-2" class="ft-funfact-section-2" <?php if($settings['bg_image']['id']){ ?>data-background="<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>"<?php } ?>>
		<div class="container">
			<?php if( $settings['subtitle'] || $settings['title'] ){ ?>
            <div class="ft-section-title-3 headline text-center">
				<?php if( $settings['subtitle'] ){ ?><span class="text-uppercase"><?php echo wp_kses($settings['subtitle'], true)?></span><?php } ?>
                <?php if( $settings['title'] ){ ?><h2><?php echo wp_kses($settings['title'], true)?></h2><?php } ?>
			</div>
            <?php } ?>
			<div class="ft-funfact-content-2 position-relative">
				<?php if($settings['map_pattern_image']['id']){ ?><span class="map-bg position-absolute text-center"><img src="<?php echo esc_url(wp_get_attachment_url($settings['map_pattern_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>"></span><?php } ?>
				<div class="ft-funfact-inner-items-wrapper position-relative">
					<div class="row">
						<?php foreach($settings['funfact'] as $key => $item): ?>
                        <div class="col-lg-3 col-md-6 col-sm-6">
							<div class="ft-funfact-inner-items text-center">
								<div class="ft-funfact-inner-icon d-flex align-items-center justify-content-center position-relative">
									<i class="<?php echo esc_attr(str_replace( "icon ",  "", $item['icons']));?>"></i>
								</div>
								<div class="ft-funfact-inner-text headline pera-content">
									<h3><span class="counter"><?php echo esc_attr($item['counter_value']);?></span><?php echo esc_attr($item['alphabet_letter']);?></h3>
									<p><?php echo wp_kses($item['block_title'], true);?></p>
								</div>
							</div>
						</div>
                        <?php endforeach; ?>
					</div>
				</div>
                <?php if( $settings['bottom_text'] ){ ?>
				<div class="ft-funfact-slug-text text-center">
					<span><?php echo wp_kses($settings['bottom_text'], true)?></span>
				</div>
                <?php } ?>
			</div>
		</div>
	</section>	
	<!-- End of Fun fact section
	============================================= -->
    <?php else:?>
    
    <section id="ft-funfact-2" class="ft-funfact-section-2" <?php if($settings['bg_image']['id']){ ?>data-background="<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>"<?php } ?>>
		<div class="container">
			<?php if( $settings['subtitle'] || $settings['title'] ){ ?>
            <div class="ft-section-title-3 headline text-center">
				<?php if( $settings['subtitle'] ){ ?><span class="text-uppercase"><?php echo wp_kses($settings['subtitle'], true)?></span><?php } ?>
                <?php if( $settings['title'] ){ ?><h2><?php echo wp_kses($settings['title'], true)?></h2><?php } ?>
			</div>
            <?php } ?>
			<div class="ft-funfact-content-2 position-relative">
				<?php if($settings['map_pattern_image']['id']){ ?><span class="map-bg position-absolute text-center"><img src="<?php echo esc_url(wp_get_attachment_url($settings['map_pattern_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>"></span><?php } ?>
				<div class="ft-funfact-inner-items-wrapper style-two position-relative">
					<div class="row">
						<?php foreach($settings['funfact'] as $key => $item): ?>
                        <div class="col-lg-3 col-md-6 col-sm-6">
							<div class="ft-funfact-inner-items style-two text-center">
								<div class="circle-one"></div>
								<div class="circle-two"></div>
                                <div class="ft-funfact-inner-icon d-flex align-items-center justify-content-center position-relative">
									<i class="<?php echo esc_attr(str_replace( "icon ",  "", $item['icons']));?>"></i>
								</div>
								<div class="ft-funfact-inner-text headline pera-content">
									<h3><span class="counter"><?php echo esc_attr($item['counter_value']);?></span><?php echo esc_attr($item['alphabet_letter']);?></h3>
									<p><?php echo wp_kses($item['block_title'], true);?></p>
								</div>
							</div>
						</div>
                        <?php endforeach; ?>
					</div>
				</div>
                <?php if( $settings['bottom_text'] ){ ?>
				<div class="ft-funfact-slug-text text-center">
					<span><?php echo wp_kses($settings['bottom_text'], true)?></span>
				</div>
                <?php } ?>
			</div>
		</div>
	</section>	
    
    <?php endif;?>
		
    <?php 
	
	}

}