<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Feature_V7 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'feature_v7';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Feature V7', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return ' eicon-form-horizontal';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'feature_section',
				[
					'label' => esc_html__( 'Features Section', 'fastrans' ),
				]
		);
        $this->add_control(
            'section_bg',
            [
                'label' => esc_html__( 'Choose Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Our Features', 'fastrans' ),
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__( 'Sub Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Why Choose Us!', 'fastrans' ),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__( 'Description', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'Quis ipsum suspendisse ultrices gravida. Risus commodo
maecenas accumsan lacus vel facilisis.', 'fastrans' ),
            ]
        );
		$this->end_controls_section();

        $this->start_controls_section(
            'feature_box_section',
            [
                'label' => __( 'Feature Box', 'fastrans' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon',
            [
                'label' => esc_html__( 'Icon', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Safe Packing', 'fastrans' ),
            ]
        );
        $repeater->add_control(
            'info',
            [
                'label' => esc_html__( 'Info', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'Do eiusmod tempor incididunt ut labore et dolore aliqua.', 'fastrans' ),
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__( 'Item List', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => esc_html__( 'Safe Packing', 'fastrans' ),
                    ],[
                        'title' => esc_html__( 'Transparent Pricing', 'fastrans' ),
                    ],[
                        'title' => esc_html__( 'Right Time Delivery', 'fastrans' ),
                    ],[
                        'title' => esc_html__( 'Fastest Shipping', 'fastrans' ),
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'feature_section_style',
			[
				'label' => esc_html__( 'Section Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'section_bg_color',
			[
				'label'     => esc_html__( 'Background Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .feature-section:before' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title.light .title' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'title_typography',
                'label'          => esc_html__( 'Title Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .sec-title.light .title',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
		$this->add_control(
			'sub_title_color',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title.light h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sub_title_typography',
				'label'          => esc_html__( 'Sub Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .sec-title.light h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
        $this->add_control(
            'description_color',
            [
                'label'     => esc_html__( 'Description Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title.light .text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'description_typography',
                'label'          => esc_html__( 'Description Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .sec-title.light .text',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
		$this->end_controls_section();
        $this->start_controls_section(
            'feature_box_style',
            [
                'label' => __( 'Feature Box Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'icon_box_bg_color',
            [
                'label'     => esc_html__( 'Icon Box BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature-block-two .inner-box' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label'     => esc_html__( 'Icon Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature-block-two .inner-box .icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color',
            [
                'label'     => esc_html__( 'Icon BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature-block-two .inner-box .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_hover_bg_color',
            [
                'label'     => esc_html__( 'Icon Hover BG Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature-block-two .inner-box:hover .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_box_title_color',
            [
                'label'     => esc_html__( 'Title Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature-block-two .inner-box h6' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'icon_Box_title_typography',
                'label'          => esc_html__( 'Title Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .feature-block-two .inner-box h6',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
        $this->add_control(
            'icon_box_info_color',
            [
                'label'     => esc_html__( 'Info Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature-block-two .inner-box .text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'icon_Box_info_typography',
                'label'          => esc_html__( 'Info Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .feature-block-two .inner-box .text',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );

        $this->end_controls_section();

	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();

	?>

        <!-- Feature Section -->
        <div class="feature-section" style="background-image:url(<?php echo $settings['section_bg']['url'];?>)">
            <div class="auto-container">
                <!-- Sec Title -->
                <div class="sec-title light centered">
                    <div class="title"><?php echo $settings['title']; ?></div>
                    <h2><?php echo $settings['sub_title']; ?></h2>
                    <div class="text"><?php echo $settings['description']; ?></div>
                </div>
                <div class="row clearfix">
                    <?php
                        foreach ($settings['items'] as $item):
                    ?>
                    <!-- Feature Block Two -->
                    <div class="feature-block-two col-lg-3 col-md-6 col-sm-12">
                        <div class="inner-box wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <div class="icon">
                                <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                            </div>
                            <h6><?php echo $item['title']; ?></h6>
                            <div class="text"><?php echo $item['info']; ?></div>
                        </div>
                    </div>

                    <?php
                        endforeach;
                    ?>

                </div>
            </div>
        </div>
        <!-- End Feature Section -->

    <?php 
	
	}

}