<?php
$options = fastrans_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );

//Light Color Logo Settings
$white_logo = $options->get( 'white_color_logo' );
$white_logo_dimension = $options->get( 'white_color_logo_dimension' );

//Mobile Logo Settings
$mobile_logo = $options->get( 'mobile_color_logo' );
$mobile_logo_dimension = $options->get( 'mobile_color_logo_dimension' );
$icons = $options->get( 'icons_social_share' );
//Header Menu Type
$header_type = get_post_meta( get_the_id(), 'header_type', true );
$fs_page_logo = get_post_meta( get_the_id(), 'fs_page_logo', true );

$logo_type = '';
$logo_text = '';
$logo_typography = ''; ?>
<!-- Main Header / Header Style Three -->
<header class="main-header header-style-three">			
        <!-- Header Top Three -->
        <div class="header-top-three">
            <div class="auto-container">
                <div class="inner-container clearfix">
                    <!-- Top Left -->
                    <div class="top-left pull-left">
                        <ul class="top-list">
                            <?php if($options->get('phone_address_v2')){ ?><li><span class="icon"><i class="fal fa-phone"></i></span><?php echo wp_kses($options->get('phone_address_v2'), true); ?></li><?php } ?>

                            <?php if($options->get('address_v5')){ ?>
                            <li><span class="icon"><i class="fal fa-map-marker"></i></span><?php echo wp_kses($options->get('address_v5'), true); ?></li><?php } ?>

                            <?php if($options->get('time_v5')){ ?>
                            <li><span class="icon"><i class="fal fa-clock"></i></span><?php echo wp_kses($options->get('time_v5'), true); ?></li><?php } ?>
                        </ul>
                    </div>
                    
                    <!-- Top Right -->
                    <div class="top-right pull-right">
                        <!-- Social Box -->
                        <ul class="social-box">
                            <span><?php esc_html_e( 'Get Our Socials:', 'fastrans' );?></span>
                            <?php foreach ( $icons as $h_icon ) :
                                $header_social_icons = json_decode( urldecode( fastrans_set( $h_icon, 'data' ) ) );
                                if ( fastrans_set( $header_social_icons, 'enable' ) == '' ) {
                                    continue;
                                }
                                $icon_class = explode( '-', fastrans_set( $header_social_icons, 'icon' ) ); ?>
                                <li><a target="_blank" href="<?php echo esc_url(fastrans_set( $header_social_icons, 'url' )); ?>" ><i class="fab <?php echo esc_attr( fastrans_set( $header_social_icons, 'icon' ) ); ?>"></i></a></li>
                                <?php endforeach; ?>
                        </ul>
                        <!-- End Social Box -->
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Header Upper -->
        <div class="header-upper">
            <div class="auto-container">
                <div class="inner-container clearfix">
                
                    <!-- Logo -->
                    <div class="pull-left logo-box">
                        <div class="logo">                        
                            <a href="<?php echo esc_url(home_url())?>"><img src="<?php echo esc_url($fs_page_logo['url']);?>" alt="<?php esc_attr_e( 'Logo', 'fastrans' );?>"></a>
                        </div>
                    </div>
                
                    <div class="nav-outer clearfix">
                        <!-- Mobile Navigation Toggler -->
                        <div class="mobile-nav-toggler"><span class="icon"><img src="<?php echo esc_url(get_template_directory_uri());?>/assets/images/icons/menu.png" alt="" /></span></div>
                        <!-- Main Menu -->
                        <nav class="main-menu navbar-expand-md">
                            <div class="navbar-header">
                                <!-- Toggle Button -->    	
                                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                </button>
                            </div>
                            
                            <div class="navbar-collapse collapse clearfix" id="navbarSupportedContent">
                                <?php 
                                if(true == $header_type){
                                    wp_nav_menu( array( 'theme_location' => 'onepage_menu', 'container_id' => 'navbar-collapse-1',
                                        'container_class'=>'navbar-collapse collapse navbar-right',
                                        'menu_class'=>'navigation clearfix',
                                    )); 
                                }else{
                                    wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
                                        'container_class'=>'navbar-collapse collapse navbar-right',
                                        'menu_class'=>'navigation clearfix',
                                    )); 
                                }
                                ?>
                                
                            </div>
                        </nav>
                        
                    </div>
                    
                </div>
            </div>
        </div>
        <!--End Header Upper-->
        
        <!-- Sticky Header  -->
        <div class="sticky-header">
            <div class="auto-container clearfix">
                <!--Logo-->
                <div class="logo pull-left">
                    <a href="<?php echo esc_url(home_url())?>"><img src="<?php echo esc_url($fs_page_logo['url']);?>" alt="<?php esc_attr_e( 'Logo', 'fastrans' );?>"></a>
                </div>
                <!--Right Col-->
                <div class="pull-right">
                    <!-- Main Menu -->
                    <nav class="main-menu">
                        <!--Keep This Empty / Menu will come through Javascript-->
                    </nav><!-- Main Menu End-->
                    
                    <!-- Main Menu End-->
                    <div class="outer-box clearfix">
                        
                        <!-- Btn Box -->
                        <?php if($options->get('btn_label_v5')){ ?>
                        <div class="btn-box">
                            <a href="<?php echo esc_url($options->get('btn_label_v5_link'));?>" class="theme-btn btn-style-one"><?php echo esc_html($options->get('btn_label_v5'));?> <span class="icon fas fa-angle-double-right"></span></a>
                        </div>
                        <?php } ?>
                        
                        <!-- Mobile Navigation Toggler -->
                        <div class="mobile-nav-toggler"><span class="icon"><img src="<?php echo esc_url(get_template_directory_uri());?>/assets/images/icons/menu.png" alt="" /></span></div>
                        
                    </div>
                    
                </div>
            </div>
        </div><!-- End Sticky Menu -->
    
        <!-- Mobile Menu  -->
        <div class="mobile-menu">
            <div class="menu-backdrop"></div>
            <div class="close-btn"><span class="icon fas fa-times"></span></div>
            
            <nav class="menu-box">
                <div class="nav-logo"><a href="<?php echo esc_url(home_url())?>"><img src="<?php echo esc_url($fs_page_logo['url']);?>" alt="<?php esc_attr_e( 'Logo', 'fastrans' );?>"></a></div>
                <div class="menu-outer"><!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header--></div>
            </nav>
        </div><!-- End Mobile Menu -->    
</header>
<!-- End Main Header -->