<?php
/**
 * Footer Template  File
 *
 * @package FASTRANS
 * @author  Template Path
 * @version 1.0
 */

$options = fastrans_WSH()->option();

$footer_logo_img4    = $options->get( 'footer_logo_img4' );
$footer_4_sb_title    = $options->get( 'footer_4_sb_title' );
$footer_4_title    = $options->get( 'footer_4_title' );
$footer_4_email    = $options->get( 'footer_4_email' );
$footer_4_phonr    = $options->get( 'footer_4_phonr' );
$footer_4_title_link    = $options->get( 'footer_4_title_link' );

$allowed_html = wp_kses_allowed_html( 'post' );
?>
	
    <!-- Start of Footer   section
	============================================= -->
	<footer id="ft-footer-4" class="ft-footer-section-4">
		<div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="footer-4-left">
                        <span><?php echo esc_html($footer_4_sb_title);?></span>
                        <h1><a href="<?php echo esc_url($footer_4_title_link);?>"><?php echo esc_html($footer_4_title);?> <i class="fal fa-long-arrow-right"></i></a></h1>
                        <div class="footer-4-info">
                            <p><i class="fas fa-phone-alt"></i> <?php echo esc_html($footer_4_phonr);?></p>
                            <p><i class="fas fa-comment"></i> <?php echo esc_html($footer_4_email);?></p>
                        </div>
                    </div>
                </div>
                <?php if ( is_active_sidebar( 'footer-sidebar4' ) ) { ?>
                <div class="col-lg-4">
                    <div class="footer-4-right">
                        <?php dynamic_sidebar( 'footer-sidebar4' ); ?>
                    </div>
                </div>
                <?php } ?>
            </div>
            <div class="row footer-4-cpr">
                <div class="col-lg-12">
                    <div class="copyright">
                        <?php echo wp_kses( $options->get( 'copyright_text3', 'Copyright @ 2021 Fastrans. All Rights Reserved.' ), true ); ?>
                    </div>                    
                </div>
            </div>
            <span class="footer-bg-shape"></span>
            <span class="footer-bg-shape-2"></span>
        </div>        
        <div class="footer-4-logo">
            <a href="">
                <img src="<?php echo esc_url($footer_logo_img4['url']);?>" alt="">
            </a>
        </div>  
        <span class="footer-s-bg"></span>      
	</footer>		
	<!-- End of FAQ why choose  section
	============================================= -->