<?php
/**
 * Footer Template  File
 *
 * @package FASTRANS
 * @author  Template Path
 * @version 1.0
 */

$options = fastrans_WSH()->option();

$bg_img    = $options->get( 'footer_bg_img' );
$bg_img    = fastrans_set( $bg_img, 'url', FASTRANS_URI . 'assets/images/bg/f-bg3.jpg' );

$allowed_html = wp_kses_allowed_html( 'post' );

?>
    
    <!-- Start Of Footer section
	============================================= -->
	<footer id="ft-footer-3" class="ft-footer-section-3" <?php if($bg_img){ ?>data-background="<?php echo esc_url($bg_img);?>"<?php } ?>>
		
		<?php if( $options->get('show_call_to_action_v1') ){ ?>
        <div  class="ft-newslatter-section-3">
			<div class="container">
				<div class="ft-newslatter-content-3 d-flex justify-content-between align-items-center">
					<?php if($options->get('cta_title_v1') || $options->get('cta_text_v1')){ ?>
                    <div class="ft-newslatter-text headline">
						<?php if($options->get('cta_title_v1')){ ?><h3><?php echo wp_kses($options->get('cta_title_v1'), true); ?></h3><?php } ?>
						<?php if($options->get('cta_text_v1')){ ?><span><?php echo wp_kses($options->get('cta_text_v1'), true); ?></span><?php } ?>
					</div>
                    <?php } ?>
					<?php if($options->get('cta_btn_link_v1') || $options->get('cta_btn_title_v1')){ ?>
                    <div class="ft-newslatter-btn position-relative">
						<a class="d-flex align-items-center justify-content-center text-uppercase" href="<?php echo esc_url($options->get('cta_btn_link_v1')); ?>"><?php echo wp_kses($options->get('cta_btn_title_v1'), true); ?></a>
					</div>
                    <?php } ?>
				</div>
			</div>
		</div>
		<?php } ?>
        
        <div class="ft-footer-widget-wrapper-3">
			<div class="container">
				<?php if ( is_active_sidebar( 'footer-sidebar' ) ) { ?>
                <div class="ft-footer-content-wrap-3">
					<div class="row">
						<?php dynamic_sidebar( 'footer-sidebar' ); ?>
					</div>
				</div>
                <?php } ?>
                
                <div class="ft-footer-copyright text-center">
                    <span><?php echo wp_kses( $options->get( 'copyright_text', '© 2021 Fastrans - Transport Services. All rights reserved.' ), true ); ?></span>
                </div>
                
			</div>
		</div>
        
	</footer>	
	<!-- End of Footer section
	============================================= -->