<?php
/**
 * Blog Post Main File.
 *
 * @package FASTRANS
 * @author  Themexriver
 * @version 1.0
 */

get_header();
$data    = \FASTRANS\Includes\Classes\Common::instance()->data( 'single' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-xs-12 col-sm-12 col-md-12' : 'col-xs-12 col-sm-12 col-md-12 col-xl-8 col-lg-7';
$options = fastrans_WSH()->option();

if ( class_exists( '\Elementor\Plugin' ) && $data->get( 'tpl-type' ) == 'e') {
	
	while(have_posts()) {
	   the_post();
	   the_content();
    }

} else {
?>

<?php if ( class_exists( '\Elementor\Plugin' )):?>
	<?php do_action( 'fastrans_banner', $data );?>
<?php else:?>
<!-- Start of Breadcrumb section
============================================= -->
<section id="ft-breadcrumb" class="ft-breadcrumb-section position-relative" data-background="'<?php echo esc_url( $data->get( 'banner' ) ); ?>'" style="background-image:url('<?php echo esc_url( $data->get( 'banner' ) ); ?>')">
    <span class="background_overlay"></span>
    <span class="design-shape position-absolute"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/shape/tmd-sh.png" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>"></span>
    <div class="container">
        <div class="ft-breadcrumb-content headline text-center position-relative">
            <h2><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h2>
            <div class="ft-breadcrumb-list ul-li">
                <ul>
                    <?php echo fastrans_the_breadcrumb(); ?>
                </ul>
            </div>
        </div>
    </div>
</section>	
<!-- End of Breadcrumb section
============================================= -->
<?php endif;?>

<!-- Start of Blog Details section
============================================= -->
<section id="ft-blog-feed-details" class="ft-blog-feed-details-section page-padding">
    <div class="container">
        <div class="ft-blog-feed-details-content">
            <div class="row">
				<?php
                    if ( $data->get( 'layout' ) == 'left' ) {
                        do_action( 'fastrans_sidebar', $data );
                    }
                ?>
                <div class="content-side <?php echo esc_attr( $class ); ?>">
                    
                    <?php while ( have_posts() ) : the_post(); ?>
                    <div class="thm-unit-test">    
                    	
                        <div class="blog-details-img-text-wrapper">        
							<?php if(has_post_thumbnail()){ ?>
                            <div class="blog-details-img position-relative">
                                <?php the_post_thumbnail('fastrans_1170x440'); ?>
                            </div>
                            <?php } ?>
                            <div class="ft-blog-details-item update">
                                <div class="blog-details-text headline">
                                    <div class="ftd-blog-meta-2  position-relative text-capitalize">
                                        <?php if( $options->get( 'single_post_author' ) ){ ?><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta('ID') )); ?>"><i class="fas fa-user"></i> <?php esc_html_e('By', 'fastrans'); ?> <?php the_author(); ?></a><?php } ?>
										<?php if( $options->get( 'single_post_date' ) ){ ?><a href="<?php echo get_month_link(get_the_date('Y'), get_the_date('m')); ?>"><i class="fas fa-calendar"></i> <?php echo esc_attr(get_the_date()); ?></a><?php } ?>
                                        <?php if(has_category()){ ?><i class="fas fa-tag"></i> <?php the_category(', '); ?><?php } ?>
                                    </div>
                                    
                                    <div class="text">
										<?php the_content(); ?>
                                        <div class="clearfix"></div>
                                        <?php wp_link_pages(array('before'=>'<div class="paginate-links">'.esc_html__('Pages: ', 'fastrans'), 'after' => '</div>', 'link_before'=>'<span>', 'link_after'=>'</span>')); ?>
                                    </div>
                                    
                                </div>
                                <?php if(function_exists('bunch_share_us_two') || has_tag()){ ?>
                                <div class="ft-blog-tag-share clearfix">
                                    <?php if(has_tag()){ ?>
                                    <div class="ft-blog-tag float-left">
                                        <span><?php esc_html_e('Tags:', 'fastrans'); ?></span>
                                        <?php the_tags( '', '', '' ); ?>
                                    </div>
                                    <?php } ?>
                                
									<?php if(function_exists('bunch_share_us_two')):?>
                                    <?php echo wp_kses(bunch_share_us_two(get_the_id(),$post->post_name ), true);?>
                                    <?php endif;?>
                                </div>
                                <?php } ?>
                            </div>
                            
                            <?php if((get_previous_post()) || (get_next_post())): ?>
                            <div class="ft-blog-next-prev d-flex justify-content-between">
                                <?php global $post; $prev_post = get_previous_post();
                                if (!empty($prev_post)):
								$post_thumbnail_id = get_post_thumbnail_id($prev_post->ID);
								$post_thumbnail_url = wp_get_attachment_url( $post_thumbnail_id );
                                ?>
                                <div class="ft-blog-next-prev-btn  ">
                                    <a class="np-text text-uppercase" href="<?php echo esc_url(get_permalink($prev_post->ID)); ?>"><i class="fas fa-angle-double-left"></i> <?php esc_html_e('Previous Post', 'fastrans'); ?></a>
                                    <div class="ft-blog-next-prev-img-text clearfix">
                                        <div class="ft-blog-np-img float-left" style="background-image:url(<?php echo esc_url($post_thumbnail_url);?>);"></div>
                                        <div class="ft-blog-np-text headline">
                                            <h3><a href="<?php echo esc_url(get_permalink($prev_post->ID)); ?>"><?php echo wp_kses_post($prev_post->post_title); ?></a></h3>
                                        </div>
                                    </div>
                                </div>
                                <?php endif ?>
                                
                                <?php global $post; $next_post = get_next_post();
                                if (!empty($next_post)):
								$post_thumbnail_id2 = get_post_thumbnail_id($next_post->ID);
                                $post_thumbnail_url2 = wp_get_attachment_url( $post_thumbnail_id2 );
                                ?>
                                <div class="ft-blog-next-prev-btn np-text-item text-right">
                                    <a class="np-text  text-uppercase" href="<?php echo esc_url(get_permalink($next_post->ID)); ?>"><?php esc_html_e('Next Post', 'fastrans'); ?> <i class="fas fa-angle-double-right"></i></a>
                                    <div class="ft-blog-next-prev-img-text d-flex clearfix">
                                        <div class="ft-blog-np-text headline">
                                            <h3><a href="<?php echo esc_url(get_permalink($next_post->ID)); ?>"><?php echo wp_kses_post($next_post->post_title); ?></a></h3>
                                        </div>
                                        <div class="ft-blog-np-img" style="background-image:url(<?php echo esc_url($post_thumbnail_url2);?>);"></div>
                                    </div>
                                </div>
                                <?php endif ?>
                            </div>
                            <?php endif ?>
                            
                        </div>
                        <!--End thm-unit-test-->
                        
                        <!--End post-details-->
                        <?php comments_template(); ?>
                    
                    </div>
                    <!--End blog-content-->
                    <?php endwhile; ?>
                    
                </div>
                <?php
                    if ( $data->get( 'layout' ) == 'right' ) {
                        do_action( 'fastrans_sidebar', $data );
                    }
                ?>
        	</div>
        </div>	
    </div>
</section>	

<?php
}
get_footer();
