<?php
return array(
	'title'      => esc_html__( 'Logo Setting', 'fastrans' ),
	'id'         => 'logo_setting',
	'desc'       => '',
	'subsection' => false,
	'fields'     => array(
		array(
			'id'       => 'image_favicon',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Favicon', 'fastrans' ),
			'subtitle' => esc_html__( 'Insert site favicon image', 'fastrans' ),
			'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/favicon.png' ),
		),
		array(
            'id' => 'normal_logo_show',
            'type' => 'switch',
            'title' => esc_html__('Enable White And Orange Color Logo', 'fastrans'),
            'default' => true,
        ),
		array(
			'id'       => 'white_and_orange_color_logo',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'White And Orange Color Logo Image', 'fastrans' ),
			'subtitle' => esc_html__( 'Insert site White And Orange Color logo image', 'fastrans' ),
			'required' => array( 'normal_logo_show', '=', true ),
		),
		array(
			'id'       => 'white_and_orange_color_logo_dimension',
			'type'     => 'dimensions',
			'title'    => esc_html__( 'White And Orange Color Logo Dimentions', 'fastrans' ),
			'subtitle' => esc_html__( 'Select White And Orange Color Logo Dimentions', 'fastrans' ),
			'units'    => array( 'em', 'px', '%' ),
			'default'  => array( 'Width' => '', 'Height' => '' ),
			'required' => array( 'normal_logo_show', '=', true ),
		),
		array(
            'id' => 'normal_logo_show2',
            'type' => 'switch',
            'title' => esc_html__('Enable White Color Logo', 'fastrans'),
            'default' => true,
        ),
		array(
			'id'       => 'white_color_logo',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'White Color Logo Image', 'fastrans' ),
			'subtitle' => esc_html__( 'Insert site White Color logo image', 'fastrans' ),
			'required' => array( 'normal_logo_show2', '=', true ),
		),
		array(
			'id'       => 'white_color_logo_dimension',
			'type'     => 'dimensions',
			'title'    => esc_html__( 'White Color Logo Dimentions', 'fastrans' ),
			'subtitle' => esc_html__( 'Select White Color Logo Dimentions', 'fastrans' ),
			'units'    => array( 'em', 'px', '%' ),
			'default'  => array( 'Width' => '', 'Height' => '' ),
			'required' => array( 'normal_logo_show2', '=', true ),
		),
		array(
            'id' => 'normal_logo_show3',
            'type' => 'switch',
            'title' => esc_html__('Enable Mobile View Logo', 'fastrans'),
            'default' => true,
        ),
		array(
			'id'       => 'mobile_color_logo',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Mobile View Logo Image', 'fastrans' ),
			'subtitle' => esc_html__( 'Insert site Mobile View logo image', 'fastrans' ),
			'required' => array( 'normal_logo_show3', '=', true ),
		),
		array(
			'id'       => 'mobile_color_logo_dimension',
			'type'     => 'dimensions',
			'title'    => esc_html__( 'Mobile View Logo Dimentions', 'fastrans' ),
			'subtitle' => esc_html__( 'Select Mobile View Logo Dimentions', 'fastrans' ),
			'units'    => array( 'em', 'px', '%' ),
			'default'  => array( 'Width' => '', 'Height' => '' ),
			'required' => array( 'normal_logo_show3', '=', true ),
		),
		array(
			'id'       => 'logo_settings_section_end',
			'type'     => 'section',
			'indent'      => false,
		),
	),
);
