<?php

return array(
	'title'      => esc_html__( '404 Page Settings', 'fastrans' ),
	'id'         => '404_setting',
	'desc'       => '',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'      => '404_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( '404 Source Type', 'fastrans' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'fastrans' ),
				'e' => esc_html__( 'Elementor', 'fastrans' ),
			),
			'default' => 'd',
		),
		array(
			'id'       => '404_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'fastrans' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
			],
			'required' => [ '404_source_type', '=', 'e' ],
		),
		array(
			'id'       => '404_default_st',
			'type'     => 'section',
			'title'    => esc_html__( '404 Default', 'fastrans' ),
			'indent'   => true,
			'required' => [ '404_source_type', '=', 'd' ],
		),
		array(
			'id'      => '404_page_banner',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Banner', 'fastrans' ),
			'desc'    => esc_html__( 'Enable to show banner on blog', 'fastrans' ),
			'default' => true,
		),
		array(
			'id'       => '404_banner_title',
			'type'     => 'text',
			'title'    => esc_html__( 'Banner Section Title', 'fastrans' ),
			'desc'     => esc_html__( 'Enter the title to show in banner section', 'fastrans' ),
			'required' => array( '404_page_banner', '=', true ),
		),
		array(
			'id'       => '404_page_background',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Background Image', 'fastrans' ),
			'desc'     => esc_html__( 'Insert background image for banner', 'fastrans' ),
			'default'  => '',
			'required' => array( '404_page_banner', '=', true ),
		),
		array(
			'id'    => '404-page_heading',
			'type'  => 'text',
			'title' => esc_html__( '404 Page Heading', 'fastrans' ),
			'desc'  => esc_html__( 'Enter 404 section Page Heading that you want to show', 'fastrans' ),
		),
		array(
			'id'    => '404-page_title',
			'type'  => 'text',
			'title' => esc_html__( '404 Title', 'fastrans' ),
			'desc'  => esc_html__( 'Enter 404 section title that you want to show', 'fastrans' ),
		),
		array(
			'id'    => '404-page-text',
			'type'  => 'textarea',
			'title' => esc_html__( '404 Page Description', 'fastrans' ),
			'desc'  => esc_html__( 'Enter 404 page description that you want to show.', 'fastrans' ),
		),
		array(
			'id'    => 'back_home_btn',
			'type'  => 'switch',
			'title' => esc_html__( 'Show Button', 'fastrans' ),
			'desc'  => esc_html__( 'Enable to show back to home button.', 'fastrans' ),
			'default'  => true,
		),
		array(
			'id'       => 'back_home_btn_label',
			'type'     => 'text',
			'title'    => esc_html__( 'Button Label', 'fastrans' ),
			'desc'     => esc_html__( 'Enter back to home button label that you want to show.', 'fastrans' ),
			'default'  => esc_html__( 'Back To Home', 'fastrans' ),
			'required' => array( 'back_home_btn', '=', true ),
		),
		array(
			'id'     => '404_post_settings_end',
			'type'   => 'section',
			'indent' => false,
		),
	),
);